@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.inputs

import com.pulumi.azurenative.databasewatcher.inputs.GetSharedPrivateLinkResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sharedPrivateLinkResourceName The Shared Private Link resource name.
 * @property watcherName The database watcher name.
 */
public data class GetSharedPrivateLinkResourcePlainArgs(
    public val resourceGroupName: String,
    public val sharedPrivateLinkResourceName: String,
    public val watcherName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.databasewatcher.inputs.GetSharedPrivateLinkResourcePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databasewatcher.inputs.GetSharedPrivateLinkResourcePlainArgs =
        com.pulumi.azurenative.databasewatcher.inputs.GetSharedPrivateLinkResourcePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sharedPrivateLinkResourceName(sharedPrivateLinkResourceName.let({ args0 -> args0 }))
            .watcherName(watcherName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSharedPrivateLinkResourcePlainArgs].
 */
@PulumiTagMarker
public class GetSharedPrivateLinkResourcePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sharedPrivateLinkResourceName: String? = null

    private var watcherName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gcjtevrbxnomnmnd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Shared Private Link resource name.
     */
    @JvmName("xgfikoblhscdxway")
    public suspend fun sharedPrivateLinkResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sharedPrivateLinkResourceName = mapped
    }

    /**
     * @param value The database watcher name.
     */
    @JvmName("rjwjfuyovgkttnqy")
    public suspend fun watcherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.watcherName = mapped
    }

    internal fun build(): GetSharedPrivateLinkResourcePlainArgs =
        GetSharedPrivateLinkResourcePlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sharedPrivateLinkResourceName = sharedPrivateLinkResourceName ?: throw
                PulumiNullFieldException("sharedPrivateLinkResourceName"),
            watcherName = watcherName ?: throw PulumiNullFieldException("watcherName"),
        )
}
