@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.inputs

import com.pulumi.azurenative.databasewatcher.inputs.VaultSecretArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The vault specific details required if using SQL authentication to connect to a target.
 * @property akvResourceId The Azure ResourceId of the Key Vault instance storing database authentication secrets.
 * @property akvTargetPassword The path to the Key Vault secret storing the password for authentication to a target.
 * @property akvTargetUser The path to the Key Vault secret storing the login name (aka user name, aka account name) for authentication to a target.
 */
public data class VaultSecretArgs(
    public val akvResourceId: Output<String>? = null,
    public val akvTargetPassword: Output<String>? = null,
    public val akvTargetUser: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databasewatcher.inputs.VaultSecretArgs> {
    override fun toJava(): com.pulumi.azurenative.databasewatcher.inputs.VaultSecretArgs =
        com.pulumi.azurenative.databasewatcher.inputs.VaultSecretArgs.builder()
            .akvResourceId(akvResourceId?.applyValue({ args0 -> args0 }))
            .akvTargetPassword(akvTargetPassword?.applyValue({ args0 -> args0 }))
            .akvTargetUser(akvTargetUser?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultSecretArgs].
 */
@PulumiTagMarker
public class VaultSecretArgsBuilder internal constructor() {
    private var akvResourceId: Output<String>? = null

    private var akvTargetPassword: Output<String>? = null

    private var akvTargetUser: Output<String>? = null

    /**
     * @param value The Azure ResourceId of the Key Vault instance storing database authentication secrets.
     */
    @JvmName("qlxbjfbdmkuvdrbv")
    public suspend fun akvResourceId(`value`: Output<String>) {
        this.akvResourceId = value
    }

    /**
     * @param value The path to the Key Vault secret storing the password for authentication to a target.
     */
    @JvmName("aebdxlbicsfdtfff")
    public suspend fun akvTargetPassword(`value`: Output<String>) {
        this.akvTargetPassword = value
    }

    /**
     * @param value The path to the Key Vault secret storing the login name (aka user name, aka account name) for authentication to a target.
     */
    @JvmName("nnsqgljwwfhljquy")
    public suspend fun akvTargetUser(`value`: Output<String>) {
        this.akvTargetUser = value
    }

    /**
     * @param value The Azure ResourceId of the Key Vault instance storing database authentication secrets.
     */
    @JvmName("oduvcywjygwmidws")
    public suspend fun akvResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.akvResourceId = mapped
    }

    /**
     * @param value The path to the Key Vault secret storing the password for authentication to a target.
     */
    @JvmName("ngljperrlnevsvcw")
    public suspend fun akvTargetPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.akvTargetPassword = mapped
    }

    /**
     * @param value The path to the Key Vault secret storing the login name (aka user name, aka account name) for authentication to a target.
     */
    @JvmName("qyypgdlccwrkpbrq")
    public suspend fun akvTargetUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.akvTargetUser = mapped
    }

    internal fun build(): VaultSecretArgs = VaultSecretArgs(
        akvResourceId = akvResourceId,
        akvTargetPassword = akvTargetPassword,
        akvTargetUser = akvTargetUser,
    )
}
