@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Concrete proxy resource types can be created by aliasing this type using a specific property type.
 * @property connectionServerName The server name to use in the connection string when connecting to a target. Port number and instance name must be specified separately.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property targetAuthenticationType The type of authentication to use when connecting to a target.
 * @property targetType Discriminator property for TargetProperties.
 * @property targetVault To use SQL authentication when connecting to targets, specify the vault where the login name and password secrets are stored.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetTargetResult(
    public val connectionServerName: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val targetAuthenticationType: String,
    public val targetType: String,
    public val targetVault: VaultSecretResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databasewatcher.outputs.GetTargetResult): GetTargetResult = GetTargetResult(
            connectionServerName = javaType.connectionServerName(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databasewatcher.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            targetAuthenticationType = javaType.targetAuthenticationType(),
            targetType = javaType.targetType(),
            targetVault = javaType.targetVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databasewatcher.kotlin.outputs.VaultSecretResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
