@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin

import com.pulumi.azurenative.databox.kotlin.outputs.CloudErrorResponse
import com.pulumi.azurenative.databox.kotlin.outputs.JobDeliveryInfoResponse
import com.pulumi.azurenative.databox.kotlin.outputs.ResourceIdentityResponse
import com.pulumi.azurenative.databox.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.databox.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.databox.kotlin.outputs.CloudErrorResponse.Companion.toKotlin as cloudErrorResponseToKotlin
import com.pulumi.azurenative.databox.kotlin.outputs.JobDeliveryInfoResponse.Companion.toKotlin as jobDeliveryInfoResponseToKotlin
import com.pulumi.azurenative.databox.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin as resourceIdentityResponseToKotlin
import com.pulumi.azurenative.databox.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.databox.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Job].
 */
@PulumiTagMarker
public class JobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobArgs = JobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobArgsBuilder.() -> Unit) {
        val builder = JobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Job {
        val builtJavaResource = com.pulumi.azurenative.databox.Job(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Job(builtJavaResource)
    }
}

/**
 * Job Resource.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-09-01, 2023-03-01, 2023-12-01, 2024-02-01-preview, 2024-03-01-preview.
 * ## Example Usage
 * ### JobsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.DataBox.Job("job", new()
 *     {
 *         Details = new AzureNative.DataBox.Inputs.DataBoxJobDetailsArgs
 *         {
 *             ContactDetails = new AzureNative.DataBox.Inputs.ContactDetailsArgs
 *             {
 *                 ContactName = "XXXX XXXX",
 *                 EmailList = new[]
 *                 {
 *                     "xxxx@xxxx.xxx",
 *                 },
 *                 Phone = "0000000000",
 *                 PhoneExtension = "",
 *             },
 *             DataImportDetails = new[]
 *             {
 *                 new AzureNative.DataBox.Inputs.DataImportDetailsArgs
 *                 {
 *                     AccountDetails = new AzureNative.DataBox.Inputs.StorageAccountDetailsArgs
 *                     {
 *                         DataAccountType = "StorageAccount",
 *                         StorageAccountId = "/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 *                     },
 *                 },
 *             },
 *             JobDetailsType = "DataBox",
 *             ShippingAddress = new AzureNative.DataBox.Inputs.ShippingAddressArgs
 *             {
 *                 AddressType = AzureNative.DataBox.AddressType.Commercial,
 *                 City = "XXXX XXXX",
 *                 CompanyName = "XXXX XXXX",
 *                 Country = "XX",
 *                 PostalCode = "00000",
 *                 StateOrProvince = "XX",
 *                 StreetAddress1 = "XXXX XXXX",
 *                 StreetAddress2 = "XXXX XXXX",
 *             },
 *         },
 *         JobName = "TestJobName1",
 *         Location = "westus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         Sku = new AzureNative.DataBox.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.DataBox.SkuName.DataBox,
 *         },
 *         TransferType = AzureNative.DataBox.TransferType.ImportToAzure,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databox/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databox.NewJob(ctx, "job", &databox.JobArgs{
 * 			Details: databox.DataBoxJobDetails{
 * 				ContactDetails: databox.ContactDetails{
 * 					ContactName: "XXXX XXXX",
 * 					EmailList: []string{
 * 						"xxxx@xxxx.xxx",
 * 					},
 * 					Phone:          "0000000000",
 * 					PhoneExtension: "",
 * 				},
 * 				DataImportDetails: []databox.DataImportDetails{
 * 					{
 * 						AccountDetails: {
 * 							DataAccountType:  "StorageAccount",
 * 							StorageAccountId: "/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 * 						},
 * 					},
 * 				},
 * 				JobDetailsType: "DataBox",
 * 				ShippingAddress: databox.ShippingAddress{
 * 					AddressType:     databox.AddressTypeCommercial,
 * 					City:            "XXXX XXXX",
 * 					CompanyName:     "XXXX XXXX",
 * 					Country:         "XX",
 * 					PostalCode:      "00000",
 * 					StateOrProvince: "XX",
 * 					StreetAddress1:  "XXXX XXXX",
 * 					StreetAddress2:  "XXXX XXXX",
 * 				},
 * 			},
 * 			JobName:           pulumi.String("TestJobName1"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			Sku: &databox.SkuArgs{
 * 				Name: pulumi.String(databox.SkuNameDataBox),
 * 			},
 * 			TransferType: pulumi.String(databox.TransferTypeImportToAzure),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databox.Job;
 * import com.pulumi.azurenative.databox.JobArgs;
 * import com.pulumi.azurenative.databox.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .details(DataBoxCustomerDiskJobDetailsArgs.builder()
 *                 .contactDetails(ContactDetailsArgs.builder()
 *                     .contactName("XXXX XXXX")
 *                     .emailList("xxxx@xxxx.xxx")
 *                     .phone("0000000000")
 *                     .phoneExtension("")
 *                     .build())
 *                 .dataImportDetails(DataImportDetailsArgs.builder()
 *                     .accountDetails(StorageAccountDetailsArgs.builder()
 *                         .dataAccountType("StorageAccount")
 *                         .storageAccountId("/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName")
 *                         .build())
 *                     .build())
 *                 .jobDetailsType("DataBox")
 *                 .shippingAddress(ShippingAddressArgs.builder()
 *                     .addressType("Commercial")
 *                     .city("XXXX XXXX")
 *                     .companyName("XXXX XXXX")
 *                     .country("XX")
 *                     .postalCode("00000")
 *                     .stateOrProvince("XX")
 *                     .streetAddress1("XXXX XXXX")
 *                     .streetAddress2("XXXX XXXX")
 *                     .build())
 *                 .build())
 *             .jobName("TestJobName1")
 *             .location("westus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .sku(SkuArgs.builder()
 *                 .name("DataBox")
 *                 .build())
 *             .transferType("ImportToAzure")
 *             .build());
 *     }
 * }
 * ```
 * ### JobsCreateDevicePassword
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.DataBox.Job("job", new()
 *     {
 *         Details = new AzureNative.DataBox.Inputs.DataBoxJobDetailsArgs
 *         {
 *             ContactDetails = new AzureNative.DataBox.Inputs.ContactDetailsArgs
 *             {
 *                 ContactName = "XXXX XXXX",
 *                 EmailList = new[]
 *                 {
 *                     "xxxx@xxxx.xxx",
 *                 },
 *                 Phone = "0000000000",
 *                 PhoneExtension = "",
 *             },
 *             DataImportDetails = new[]
 *             {
 *                 new AzureNative.DataBox.Inputs.DataImportDetailsArgs
 *                 {
 *                     AccountDetails = new AzureNative.DataBox.Inputs.StorageAccountDetailsArgs
 *                     {
 *                         DataAccountType = "StorageAccount",
 *                         SharePassword = "<sharePassword>",
 *                         StorageAccountId = "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 *                     },
 *                 },
 *             },
 *             DevicePassword = "<devicePassword>",
 *             JobDetailsType = "DataBox",
 *             ShippingAddress = new AzureNative.DataBox.Inputs.ShippingAddressArgs
 *             {
 *                 AddressType = AzureNative.DataBox.AddressType.Commercial,
 *                 City = "XXXX XXXX",
 *                 CompanyName = "XXXX XXXX",
 *                 Country = "XX",
 *                 PostalCode = "00000",
 *                 StateOrProvince = "XX",
 *                 StreetAddress1 = "XXXX XXXX",
 *                 StreetAddress2 = "XXXX XXXX",
 *             },
 *         },
 *         JobName = "TestJobName1",
 *         Location = "westus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         Sku = new AzureNative.DataBox.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.DataBox.SkuName.DataBox,
 *         },
 *         TransferType = AzureNative.DataBox.TransferType.ImportToAzure,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databox/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databox.NewJob(ctx, "job", &databox.JobArgs{
 * 			Details: databox.DataBoxJobDetails{
 * 				ContactDetails: databox.ContactDetails{
 * 					ContactName: "XXXX XXXX",
 * 					EmailList: []string{
 * 						"xxxx@xxxx.xxx",
 * 					},
 * 					Phone:          "0000000000",
 * 					PhoneExtension: "",
 * 				},
 * 				DataImportDetails: []databox.DataImportDetails{
 * 					{
 * 						AccountDetails: {
 * 							DataAccountType:  "StorageAccount",
 * 							SharePassword:    "<sharePassword>",
 * 							StorageAccountId: "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 * 						},
 * 					},
 * 				},
 * 				DevicePassword: "<devicePassword>",
 * 				JobDetailsType: "DataBox",
 * 				ShippingAddress: databox.ShippingAddress{
 * 					AddressType:     databox.AddressTypeCommercial,
 * 					City:            "XXXX XXXX",
 * 					CompanyName:     "XXXX XXXX",
 * 					Country:         "XX",
 * 					PostalCode:      "00000",
 * 					StateOrProvince: "XX",
 * 					StreetAddress1:  "XXXX XXXX",
 * 					StreetAddress2:  "XXXX XXXX",
 * 				},
 * 			},
 * 			JobName:           pulumi.String("TestJobName1"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			Sku: &databox.SkuArgs{
 * 				Name: pulumi.String(databox.SkuNameDataBox),
 * 			},
 * 			TransferType: pulumi.String(databox.TransferTypeImportToAzure),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databox.Job;
 * import com.pulumi.azurenative.databox.JobArgs;
 * import com.pulumi.azurenative.databox.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .details(DataBoxCustomerDiskJobDetailsArgs.builder()
 *                 .contactDetails(ContactDetailsArgs.builder()
 *                     .contactName("XXXX XXXX")
 *                     .emailList("xxxx@xxxx.xxx")
 *                     .phone("0000000000")
 *                     .phoneExtension("")
 *                     .build())
 *                 .dataImportDetails(DataImportDetailsArgs.builder()
 *                     .accountDetails(StorageAccountDetailsArgs.builder()
 *                         .dataAccountType("StorageAccount")
 *                         .sharePassword("<sharePassword>")
 *                         .storageAccountId("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName")
 *                         .build())
 *                     .build())
 *                 .devicePassword("<devicePassword>")
 *                 .jobDetailsType("DataBox")
 *                 .shippingAddress(ShippingAddressArgs.builder()
 *                     .addressType("Commercial")
 *                     .city("XXXX XXXX")
 *                     .companyName("XXXX XXXX")
 *                     .country("XX")
 *                     .postalCode("00000")
 *                     .stateOrProvince("XX")
 *                     .streetAddress1("XXXX XXXX")
 *                     .streetAddress2("XXXX XXXX")
 *                     .build())
 *                 .build())
 *             .jobName("TestJobName1")
 *             .location("westus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .sku(SkuArgs.builder()
 *                 .name("DataBox")
 *                 .build())
 *             .transferType("ImportToAzure")
 *             .build());
 *     }
 * }
 * ```
 * ### JobsCreateDoubleEncryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.DataBox.Job("job", new()
 *     {
 *         Details = new AzureNative.DataBox.Inputs.DataBoxJobDetailsArgs
 *         {
 *             ContactDetails = new AzureNative.DataBox.Inputs.ContactDetailsArgs
 *             {
 *                 ContactName = "XXXX XXXX",
 *                 EmailList = new[]
 *                 {
 *                     "xxxx@xxxx.xxx",
 *                 },
 *                 Phone = "0000000000",
 *                 PhoneExtension = "",
 *             },
 *             DataImportDetails = new[]
 *             {
 *                 new AzureNative.DataBox.Inputs.DataImportDetailsArgs
 *                 {
 *                     AccountDetails = new AzureNative.DataBox.Inputs.StorageAccountDetailsArgs
 *                     {
 *                         DataAccountType = "StorageAccount",
 *                         StorageAccountId = "/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 *                     },
 *                 },
 *             },
 *             JobDetailsType = "DataBox",
 *             Preferences = new AzureNative.DataBox.Inputs.PreferencesArgs
 *             {
 *                 EncryptionPreferences = new AzureNative.DataBox.Inputs.EncryptionPreferencesArgs
 *                 {
 *                     DoubleEncryption = AzureNative.DataBox.DoubleEncryption.Enabled,
 *                 },
 *             },
 *             ShippingAddress = new AzureNative.DataBox.Inputs.ShippingAddressArgs
 *             {
 *                 AddressType = AzureNative.DataBox.AddressType.Commercial,
 *                 City = "XXXX XXXX",
 *                 CompanyName = "XXXX XXXX",
 *                 Country = "XX",
 *                 PostalCode = "00000",
 *                 StateOrProvince = "XX",
 *                 StreetAddress1 = "XXXX XXXX",
 *                 StreetAddress2 = "XXXX XXXX",
 *             },
 *         },
 *         JobName = "TestJobName1",
 *         Location = "westus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         Sku = new AzureNative.DataBox.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.DataBox.SkuName.DataBox,
 *         },
 *         TransferType = AzureNative.DataBox.TransferType.ImportToAzure,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databox/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databox.NewJob(ctx, "job", &databox.JobArgs{
 * 			Details: databox.DataBoxJobDetails{
 * 				ContactDetails: databox.ContactDetails{
 * 					ContactName: "XXXX XXXX",
 * 					EmailList: []string{
 * 						"xxxx@xxxx.xxx",
 * 					},
 * 					Phone:          "0000000000",
 * 					PhoneExtension: "",
 * 				},
 * 				DataImportDetails: []databox.DataImportDetails{
 * 					{
 * 						AccountDetails: {
 * 							DataAccountType:  "StorageAccount",
 * 							StorageAccountId: "/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 * 						},
 * 					},
 * 				},
 * 				JobDetailsType: "DataBox",
 * 				Preferences: databox.Preferences{
 * 					EncryptionPreferences: databox.EncryptionPreferences{
 * 						DoubleEncryption: databox.DoubleEncryptionEnabled,
 * 					},
 * 				},
 * 				ShippingAddress: databox.ShippingAddress{
 * 					AddressType:     databox.AddressTypeCommercial,
 * 					City:            "XXXX XXXX",
 * 					CompanyName:     "XXXX XXXX",
 * 					Country:         "XX",
 * 					PostalCode:      "00000",
 * 					StateOrProvince: "XX",
 * 					StreetAddress1:  "XXXX XXXX",
 * 					StreetAddress2:  "XXXX XXXX",
 * 				},
 * 			},
 * 			JobName:           pulumi.String("TestJobName1"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			Sku: &databox.SkuArgs{
 * 				Name: pulumi.String(databox.SkuNameDataBox),
 * 			},
 * 			TransferType: pulumi.String(databox.TransferTypeImportToAzure),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databox.Job;
 * import com.pulumi.azurenative.databox.JobArgs;
 * import com.pulumi.azurenative.databox.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .details(DataBoxCustomerDiskJobDetailsArgs.builder()
 *                 .contactDetails(ContactDetailsArgs.builder()
 *                     .contactName("XXXX XXXX")
 *                     .emailList("xxxx@xxxx.xxx")
 *                     .phone("0000000000")
 *                     .phoneExtension("")
 *                     .build())
 *                 .dataImportDetails(DataImportDetailsArgs.builder()
 *                     .accountDetails(StorageAccountDetailsArgs.builder()
 *                         .dataAccountType("StorageAccount")
 *                         .storageAccountId("/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName")
 *                         .build())
 *                     .build())
 *                 .jobDetailsType("DataBox")
 *                 .preferences(PreferencesArgs.builder()
 *                     .encryptionPreferences(EncryptionPreferencesArgs.builder()
 *                         .doubleEncryption("Enabled")
 *                         .build())
 *                     .build())
 *                 .shippingAddress(ShippingAddressArgs.builder()
 *                     .addressType("Commercial")
 *                     .city("XXXX XXXX")
 *                     .companyName("XXXX XXXX")
 *                     .country("XX")
 *                     .postalCode("00000")
 *                     .stateOrProvince("XX")
 *                     .streetAddress1("XXXX XXXX")
 *                     .streetAddress2("XXXX XXXX")
 *                     .build())
 *                 .build())
 *             .jobName("TestJobName1")
 *             .location("westus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .sku(SkuArgs.builder()
 *                 .name("DataBox")
 *                 .build())
 *             .transferType("ImportToAzure")
 *             .build());
 *     }
 * }
 * ```
 * ### JobsCreateExport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.DataBox.Job("job", new()
 *     {
 *         Details = new AzureNative.DataBox.Inputs.DataBoxJobDetailsArgs
 *         {
 *             ContactDetails = new AzureNative.DataBox.Inputs.ContactDetailsArgs
 *             {
 *                 ContactName = "XXXX XXXX",
 *                 EmailList = new[]
 *                 {
 *                     "xxxx@xxxx.xxx",
 *                 },
 *                 Phone = "0000000000",
 *                 PhoneExtension = "",
 *             },
 *             DataExportDetails = new[]
 *             {
 *                 new AzureNative.DataBox.Inputs.DataExportDetailsArgs
 *                 {
 *                     AccountDetails = new AzureNative.DataBox.Inputs.StorageAccountDetailsArgs
 *                     {
 *                         DataAccountType = "StorageAccount",
 *                         StorageAccountId = "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 *                     },
 *                     TransferConfiguration = new AzureNative.DataBox.Inputs.TransferConfigurationArgs
 *                     {
 *                         TransferAllDetails = new AzureNative.DataBox.Inputs.TransferConfigurationTransferAllDetailsArgs
 *                         {
 *                             Include = new AzureNative.DataBox.Inputs.TransferAllDetailsArgs
 *                             {
 *                                 DataAccountType = AzureNative.DataBox.DataAccountType.StorageAccount,
 *                                 TransferAllBlobs = true,
 *                                 TransferAllFiles = true,
 *                             },
 *                         },
 *                         TransferConfigurationType = AzureNative.DataBox.TransferConfigurationType.TransferAll,
 *                     },
 *                 },
 *             },
 *             JobDetailsType = "DataBox",
 *             ShippingAddress = new AzureNative.DataBox.Inputs.ShippingAddressArgs
 *             {
 *                 AddressType = AzureNative.DataBox.AddressType.Commercial,
 *                 City = "XXXX XXXX",
 *                 CompanyName = "XXXX XXXX",
 *                 Country = "XX",
 *                 PostalCode = "00000",
 *                 StateOrProvince = "XX",
 *                 StreetAddress1 = "XXXX XXXX",
 *                 StreetAddress2 = "XXXX XXXX",
 *             },
 *         },
 *         JobName = "TestJobName1",
 *         Location = "westus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         Sku = new AzureNative.DataBox.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.DataBox.SkuName.DataBox,
 *         },
 *         TransferType = AzureNative.DataBox.TransferType.ExportFromAzure,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databox/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databox.NewJob(ctx, "job", &databox.JobArgs{
 * 			Details: databox.DataBoxJobDetails{
 * 				ContactDetails: databox.ContactDetails{
 * 					ContactName: "XXXX XXXX",
 * 					EmailList: []string{
 * 						"xxxx@xxxx.xxx",
 * 					},
 * 					Phone:          "0000000000",
 * 					PhoneExtension: "",
 * 				},
 * 				DataExportDetails: []databox.DataExportDetails{
 * 					{
 * 						AccountDetails: {
 * 							DataAccountType:  "StorageAccount",
 * 							StorageAccountId: "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 * 						},
 * 						TransferConfiguration: {
 * 							TransferAllDetails: {
 * 								Include: {
 * 									DataAccountType:  databox.DataAccountTypeStorageAccount,
 * 									TransferAllBlobs: true,
 * 									TransferAllFiles: true,
 * 								},
 * 							},
 * 							TransferConfigurationType: databox.TransferConfigurationTypeTransferAll,
 * 						},
 * 					},
 * 				},
 * 				JobDetailsType: "DataBox",
 * 				ShippingAddress: databox.ShippingAddress{
 * 					AddressType:     databox.AddressTypeCommercial,
 * 					City:            "XXXX XXXX",
 * 					CompanyName:     "XXXX XXXX",
 * 					Country:         "XX",
 * 					PostalCode:      "00000",
 * 					StateOrProvince: "XX",
 * 					StreetAddress1:  "XXXX XXXX",
 * 					StreetAddress2:  "XXXX XXXX",
 * 				},
 * 			},
 * 			JobName:           pulumi.String("TestJobName1"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			Sku: &databox.SkuArgs{
 * 				Name: pulumi.String(databox.SkuNameDataBox),
 * 			},
 * 			TransferType: pulumi.String(databox.TransferTypeExportFromAzure),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databox.Job;
 * import com.pulumi.azurenative.databox.JobArgs;
 * import com.pulumi.azurenative.databox.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .details(DataBoxCustomerDiskJobDetailsArgs.builder()
 *                 .contactDetails(ContactDetailsArgs.builder()
 *                     .contactName("XXXX XXXX")
 *                     .emailList("xxxx@xxxx.xxx")
 *                     .phone("0000000000")
 *                     .phoneExtension("")
 *                     .build())
 *                 .dataExportDetails(DataExportDetailsArgs.builder()
 *                     .accountDetails(StorageAccountDetailsArgs.builder()
 *                         .dataAccountType("StorageAccount")
 *                         .storageAccountId("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName")
 *                         .build())
 *                     .transferConfiguration(TransferConfigurationArgs.builder()
 *                         .transferAllDetails(TransferConfigurationTransferAllDetailsArgs.builder()
 *                             .include(TransferAllDetailsArgs.builder()
 *                                 .dataAccountType("StorageAccount")
 *                                 .transferAllBlobs(true)
 *                                 .transferAllFiles(true)
 *                                 .build())
 *                             .build())
 *                         .transferConfigurationType("TransferAll")
 *                         .build())
 *                     .build())
 *                 .jobDetailsType("DataBox")
 *                 .shippingAddress(ShippingAddressArgs.builder()
 *                     .addressType("Commercial")
 *                     .city("XXXX XXXX")
 *                     .companyName("XXXX XXXX")
 *                     .country("XX")
 *                     .postalCode("00000")
 *                     .stateOrProvince("XX")
 *                     .streetAddress1("XXXX XXXX")
 *                     .streetAddress2("XXXX XXXX")
 *                     .build())
 *                 .build())
 *             .jobName("TestJobName1")
 *             .location("westus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .sku(SkuArgs.builder()
 *                 .name("DataBox")
 *                 .build())
 *             .transferType("ExportFromAzure")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databox:Job TestJobName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}
 * ```
 */
public class Job internal constructor(
    override val javaResource: com.pulumi.azurenative.databox.Job,
) : KotlinCustomResource(javaResource, JobMapper) {
    /**
     * Reason for cancellation.
     */
    public val cancellationReason: Output<String>
        get() = javaResource.cancellationReason().applyValue({ args0 -> args0 })

    /**
     * Delivery Info of Job.
     */
    public val deliveryInfo: Output<JobDeliveryInfoResponse>?
        get() = javaResource.deliveryInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    jobDeliveryInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Delivery type of Job.
     */
    public val deliveryType: Output<String>?
        get() = javaResource.deliveryType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Details of a job run. This field will only be sent for expand details filter.
     */
    public val details: Output<Any>?
        get() = javaResource.details().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Top level error for the job.
     */
    public val error: Output<CloudErrorResponse>
        get() = javaResource.error().applyValue({ args0 ->
            args0.let({ args0 ->
                cloudErrorResponseToKotlin(args0)
            })
        })

    /**
     * Msi identity of the resource
     */
    public val identity: Output<ResourceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Describes whether the job is cancellable or not.
     */
    public val isCancellable: Output<Boolean>
        get() = javaResource.isCancellable().applyValue({ args0 -> args0 })

    /**
     * Flag to indicate cancellation of scheduled job.
     */
    public val isCancellableWithoutFee: Output<Boolean>
        get() = javaResource.isCancellableWithoutFee().applyValue({ args0 -> args0 })

    /**
     * Describes whether the job is deletable or not.
     */
    public val isDeletable: Output<Boolean>
        get() = javaResource.isDeletable().applyValue({ args0 -> args0 })

    /**
     * Is Prepare To Ship Enabled on this job
     */
    public val isPrepareToShipEnabled: Output<Boolean>
        get() = javaResource.isPrepareToShipEnabled().applyValue({ args0 -> args0 })

    /**
     * Describes whether the shipping address is editable or not.
     */
    public val isShippingAddressEditable: Output<Boolean>
        get() = javaResource.isShippingAddressEditable().applyValue({ args0 -> args0 })

    /**
     * The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Name of the object.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Editable status for Reverse Shipping Address and Contact Info
     */
    public val reverseShippingDetailsUpdate: Output<String>
        get() = javaResource.reverseShippingDetailsUpdate().applyValue({ args0 -> args0 })

    /**
     * The Editable status for Reverse Transport preferences
     */
    public val reverseTransportPreferenceUpdate: Output<String>
        get() = javaResource.reverseTransportPreferenceUpdate().applyValue({ args0 -> args0 })

    /**
     * The sku type.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Time at which the job was started in UTC ISO 8601 format.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * Name of the stage which is in progress.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of the data transfer.
     */
    public val transferType: Output<String>
        get() = javaResource.transferType().applyValue({ args0 -> args0 })

    /**
     * Type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobMapper : ResourceMapper<Job> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databox.Job::class == javaResource::class

    override fun map(javaResource: Resource): Job = Job(
        javaResource as
            com.pulumi.azurenative.databox.Job,
    )
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Job].
 */
public suspend fun job(name: String, block: suspend JobResourceBuilder.() -> Unit): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 */
public fun job(name: String): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    return builder.build()
}
