@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the filter file.
 */
public enum class FilterFileType(
    public val javaValue: com.pulumi.azurenative.databox.enums.FilterFileType,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.FilterFileType> {
    /**
     * Filter file is of the type AzureBlob.
     */
    AzureBlob(com.pulumi.azurenative.databox.enums.FilterFileType.AzureBlob),

    /**
     * Filter file is of the type AzureFiles.
     */
    AzureFile(com.pulumi.azurenative.databox.enums.FilterFileType.AzureFile),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.FilterFileType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.FilterFileType): FilterFileType = FilterFileType.values().first { it.javaValue == javaType }
    }
}
