@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines Hardware level encryption (Only for disk)
 */
public enum class HardwareEncryption(
    public val javaValue: com.pulumi.azurenative.databox.enums.HardwareEncryption,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.HardwareEncryption> {
    /**
     * Hardware-based encryption is enabled.
     */
    Enabled(com.pulumi.azurenative.databox.enums.HardwareEncryption.Enabled),

    /**
     * Hardware-based encryption is enabled.
     */
    Disabled(com.pulumi.azurenative.databox.enums.HardwareEncryption.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.HardwareEncryption = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.HardwareEncryption): HardwareEncryption = HardwareEncryption.values().first { it.javaValue == javaType }
    }
}
