@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Delivery type of Job.
 */
public enum class JobDeliveryType(
    public val javaValue: com.pulumi.azurenative.databox.enums.JobDeliveryType,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.JobDeliveryType> {
    /**
     * Non Scheduled job.
     */
    NonScheduled(com.pulumi.azurenative.databox.enums.JobDeliveryType.NonScheduled),

    /**
     * Scheduled job.
     */
    Scheduled(com.pulumi.azurenative.databox.enums.JobDeliveryType.Scheduled),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.JobDeliveryType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.JobDeliveryType): JobDeliveryType = JobDeliveryType.values().first { it.javaValue == javaType }
    }
}
