@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the configuration for transfer.
 */
public enum class TransferConfigurationType(
    public val javaValue: com.pulumi.azurenative.databox.enums.TransferConfigurationType,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.TransferConfigurationType> {
    /**
     * Transfer all the data.
     */
    TransferAll(com.pulumi.azurenative.databox.enums.TransferConfigurationType.TransferAll),

    /**
     * Transfer using filter.
     */
    TransferUsingFilter(com.pulumi.azurenative.databox.enums.TransferConfigurationType.TransferUsingFilter),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.TransferConfigurationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.TransferConfigurationType): TransferConfigurationType =
            TransferConfigurationType.values().first { it.javaValue == javaType }
    }
}
