@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the data transfer.
 */
public enum class TransferType(
    public val javaValue: com.pulumi.azurenative.databox.enums.TransferType,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.TransferType> {
    /**
     * Import data to azure.
     */
    ImportToAzure(com.pulumi.azurenative.databox.enums.TransferType.ImportToAzure),

    /**
     * Export data from azure.
     */
    ExportFromAzure(com.pulumi.azurenative.databox.enums.TransferType.ExportFromAzure),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.TransferType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.TransferType): TransferType =
            TransferType.values().first { it.javaValue == javaType }
    }
}
