@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.BlobFilterDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Filter details to transfer Azure Blobs
 * @property blobPathList List of full path of the blobs to be transferred.
 * @property blobPrefixList Prefix list of the Azure blobs to be transferred.
 * @property containerList List of blob containers to be transferred.
 */
public data class BlobFilterDetailsArgs(
    public val blobPathList: Output<List<String>>? = null,
    public val blobPrefixList: Output<List<String>>? = null,
    public val containerList: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.BlobFilterDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.BlobFilterDetailsArgs =
        com.pulumi.azurenative.databox.inputs.BlobFilterDetailsArgs.builder()
            .blobPathList(blobPathList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .blobPrefixList(blobPrefixList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .containerList(containerList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BlobFilterDetailsArgs].
 */
@PulumiTagMarker
public class BlobFilterDetailsArgsBuilder internal constructor() {
    private var blobPathList: Output<List<String>>? = null

    private var blobPrefixList: Output<List<String>>? = null

    private var containerList: Output<List<String>>? = null

    /**
     * @param value List of full path of the blobs to be transferred.
     */
    @JvmName("rrpfqtqssawkgtav")
    public suspend fun blobPathList(`value`: Output<List<String>>) {
        this.blobPathList = value
    }

    @JvmName("kbmgqnfhshotfire")
    public suspend fun blobPathList(vararg values: Output<String>) {
        this.blobPathList = Output.all(values.asList())
    }

    /**
     * @param values List of full path of the blobs to be transferred.
     */
    @JvmName("bumyqbcryvdukeub")
    public suspend fun blobPathList(values: List<Output<String>>) {
        this.blobPathList = Output.all(values)
    }

    /**
     * @param value Prefix list of the Azure blobs to be transferred.
     */
    @JvmName("ggoteucmgucarbfi")
    public suspend fun blobPrefixList(`value`: Output<List<String>>) {
        this.blobPrefixList = value
    }

    @JvmName("hfnwkwgvqeivknbk")
    public suspend fun blobPrefixList(vararg values: Output<String>) {
        this.blobPrefixList = Output.all(values.asList())
    }

    /**
     * @param values Prefix list of the Azure blobs to be transferred.
     */
    @JvmName("ktdaatjaxjahushn")
    public suspend fun blobPrefixList(values: List<Output<String>>) {
        this.blobPrefixList = Output.all(values)
    }

    /**
     * @param value List of blob containers to be transferred.
     */
    @JvmName("mouuewnmlmygpxfx")
    public suspend fun containerList(`value`: Output<List<String>>) {
        this.containerList = value
    }

    @JvmName("einyosnrqalincxa")
    public suspend fun containerList(vararg values: Output<String>) {
        this.containerList = Output.all(values.asList())
    }

    /**
     * @param values List of blob containers to be transferred.
     */
    @JvmName("eeyyxjphvfwqasev")
    public suspend fun containerList(values: List<Output<String>>) {
        this.containerList = Output.all(values)
    }

    /**
     * @param value List of full path of the blobs to be transferred.
     */
    @JvmName("rfrdipvkoyolsvml")
    public suspend fun blobPathList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobPathList = mapped
    }

    /**
     * @param values List of full path of the blobs to be transferred.
     */
    @JvmName("yaioiqrewckabvgj")
    public suspend fun blobPathList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobPathList = mapped
    }

    /**
     * @param value Prefix list of the Azure blobs to be transferred.
     */
    @JvmName("htrgkqywsrlnlamu")
    public suspend fun blobPrefixList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobPrefixList = mapped
    }

    /**
     * @param values Prefix list of the Azure blobs to be transferred.
     */
    @JvmName("djvfobwtatcucjnt")
    public suspend fun blobPrefixList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobPrefixList = mapped
    }

    /**
     * @param value List of blob containers to be transferred.
     */
    @JvmName("mniomedaeuxuhotw")
    public suspend fun containerList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerList = mapped
    }

    /**
     * @param values List of blob containers to be transferred.
     */
    @JvmName("hoqbqxholxfrinou")
    public suspend fun containerList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerList = mapped
    }

    internal fun build(): BlobFilterDetailsArgs = BlobFilterDetailsArgs(
        blobPathList = blobPathList,
        blobPrefixList = blobPrefixList,
        containerList = containerList,
    )
}
