@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.DataBoxCustomerDiskJobDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Customer disk job details.
 * @property contactDetails Contact details for notification and shipping.
 * @property dataExportDetails Details of the data to be exported from azure.
 * @property dataImportDetails Details of the data to be imported into azure.
 * @property enableManifestBackup Flag to indicate if disk manifest should be backed-up in the Storage Account.
 * @property expectedDataSizeInTeraBytes The expected size of the data, which needs to be transferred in this job, in terabytes.
 * @property importDiskDetailsCollection Contains the map of disk serial number to the disk details for import jobs.
 * @property jobDetailsType Indicates the type of job details.
 * Expected value is 'DataBoxCustomerDisk'.
 * @property keyEncryptionKey Details about which key encryption type is being used.
 * @property preferences Preferences for the order.
 * @property returnToCustomerPackageDetails Return package shipping details.
 * @property reverseShippingDetails Optional Reverse Shipping details for order.
 * @property shippingAddress Shipping address of the customer.
 */
public data class DataBoxCustomerDiskJobDetailsArgs(
    public val contactDetails: Output<ContactDetailsArgs>,
    public val dataExportDetails: Output<List<DataExportDetailsArgs>>? = null,
    public val dataImportDetails: Output<List<DataImportDetailsArgs>>? = null,
    public val enableManifestBackup: Output<Boolean>? = null,
    public val expectedDataSizeInTeraBytes: Output<Int>? = null,
    public val importDiskDetailsCollection: Output<Map<String, ImportDiskDetailsArgs>>? = null,
    public val jobDetailsType: Output<String>,
    public val keyEncryptionKey: Output<KeyEncryptionKeyArgs>? = null,
    public val preferences: Output<PreferencesArgs>? = null,
    public val returnToCustomerPackageDetails: Output<PackageCarrierDetailsArgs>,
    public val reverseShippingDetails: Output<ReverseShippingDetailsArgs>? = null,
    public val shippingAddress: Output<ShippingAddressArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.DataBoxCustomerDiskJobDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.DataBoxCustomerDiskJobDetailsArgs =
        com.pulumi.azurenative.databox.inputs.DataBoxCustomerDiskJobDetailsArgs.builder()
            .contactDetails(contactDetails.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataExportDetails(
                dataExportDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dataImportDetails(
                dataImportDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableManifestBackup(enableManifestBackup?.applyValue({ args0 -> args0 }))
            .expectedDataSizeInTeraBytes(expectedDataSizeInTeraBytes?.applyValue({ args0 -> args0 }))
            .importDiskDetailsCollection(
                importDiskDetailsCollection?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .jobDetailsType(jobDetailsType.applyValue({ args0 -> args0 }))
            .keyEncryptionKey(keyEncryptionKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preferences(preferences?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .returnToCustomerPackageDetails(
                returnToCustomerPackageDetails.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .reverseShippingDetails(
                reverseShippingDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .shippingAddress(
                shippingAddress?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataBoxCustomerDiskJobDetailsArgs].
 */
@PulumiTagMarker
public class DataBoxCustomerDiskJobDetailsArgsBuilder internal constructor() {
    private var contactDetails: Output<ContactDetailsArgs>? = null

    private var dataExportDetails: Output<List<DataExportDetailsArgs>>? = null

    private var dataImportDetails: Output<List<DataImportDetailsArgs>>? = null

    private var enableManifestBackup: Output<Boolean>? = null

    private var expectedDataSizeInTeraBytes: Output<Int>? = null

    private var importDiskDetailsCollection: Output<Map<String, ImportDiskDetailsArgs>>? = null

    private var jobDetailsType: Output<String>? = null

    private var keyEncryptionKey: Output<KeyEncryptionKeyArgs>? = null

    private var preferences: Output<PreferencesArgs>? = null

    private var returnToCustomerPackageDetails: Output<PackageCarrierDetailsArgs>? = null

    private var reverseShippingDetails: Output<ReverseShippingDetailsArgs>? = null

    private var shippingAddress: Output<ShippingAddressArgs>? = null

    /**
     * @param value Contact details for notification and shipping.
     */
    @JvmName("hbkfrvvwvqcpbwvs")
    public suspend fun contactDetails(`value`: Output<ContactDetailsArgs>) {
        this.contactDetails = value
    }

    /**
     * @param value Details of the data to be exported from azure.
     */
    @JvmName("dmuthumeulfeqgrw")
    public suspend fun dataExportDetails(`value`: Output<List<DataExportDetailsArgs>>) {
        this.dataExportDetails = value
    }

    @JvmName("bdjrcesiidlvvwpx")
    public suspend fun dataExportDetails(vararg values: Output<DataExportDetailsArgs>) {
        this.dataExportDetails = Output.all(values.asList())
    }

    /**
     * @param values Details of the data to be exported from azure.
     */
    @JvmName("bsjupgnhnlnfysuc")
    public suspend fun dataExportDetails(values: List<Output<DataExportDetailsArgs>>) {
        this.dataExportDetails = Output.all(values)
    }

    /**
     * @param value Details of the data to be imported into azure.
     */
    @JvmName("unnmheeblbdfompf")
    public suspend fun dataImportDetails(`value`: Output<List<DataImportDetailsArgs>>) {
        this.dataImportDetails = value
    }

    @JvmName("niyfmdqallkudaqn")
    public suspend fun dataImportDetails(vararg values: Output<DataImportDetailsArgs>) {
        this.dataImportDetails = Output.all(values.asList())
    }

    /**
     * @param values Details of the data to be imported into azure.
     */
    @JvmName("fkaibvjupogbeato")
    public suspend fun dataImportDetails(values: List<Output<DataImportDetailsArgs>>) {
        this.dataImportDetails = Output.all(values)
    }

    /**
     * @param value Flag to indicate if disk manifest should be backed-up in the Storage Account.
     */
    @JvmName("kxqdsiyvgkjydqub")
    public suspend fun enableManifestBackup(`value`: Output<Boolean>) {
        this.enableManifestBackup = value
    }

    /**
     * @param value The expected size of the data, which needs to be transferred in this job, in terabytes.
     */
    @JvmName("avteucwcqeyyhsrt")
    public suspend fun expectedDataSizeInTeraBytes(`value`: Output<Int>) {
        this.expectedDataSizeInTeraBytes = value
    }

    /**
     * @param value Contains the map of disk serial number to the disk details for import jobs.
     */
    @JvmName("gkpvrqonmonuvnyw")
    public suspend fun importDiskDetailsCollection(`value`: Output<Map<String, ImportDiskDetailsArgs>>) {
        this.importDiskDetailsCollection = value
    }

    /**
     * @param value Indicates the type of job details.
     * Expected value is 'DataBoxCustomerDisk'.
     */
    @JvmName("atkpokuxnldumwyu")
    public suspend fun jobDetailsType(`value`: Output<String>) {
        this.jobDetailsType = value
    }

    /**
     * @param value Details about which key encryption type is being used.
     */
    @JvmName("ibwdwiusdtvyvwmr")
    public suspend fun keyEncryptionKey(`value`: Output<KeyEncryptionKeyArgs>) {
        this.keyEncryptionKey = value
    }

    /**
     * @param value Preferences for the order.
     */
    @JvmName("rovtrhrcumqujjwa")
    public suspend fun preferences(`value`: Output<PreferencesArgs>) {
        this.preferences = value
    }

    /**
     * @param value Return package shipping details.
     */
    @JvmName("thgbfmujcvltonof")
    public suspend fun returnToCustomerPackageDetails(`value`: Output<PackageCarrierDetailsArgs>) {
        this.returnToCustomerPackageDetails = value
    }

    /**
     * @param value Optional Reverse Shipping details for order.
     */
    @JvmName("folgwotvsxkeywhq")
    public suspend fun reverseShippingDetails(`value`: Output<ReverseShippingDetailsArgs>) {
        this.reverseShippingDetails = value
    }

    /**
     * @param value Shipping address of the customer.
     */
    @JvmName("wphbuhsjmtxtobai")
    public suspend fun shippingAddress(`value`: Output<ShippingAddressArgs>) {
        this.shippingAddress = value
    }

    /**
     * @param value Contact details for notification and shipping.
     */
    @JvmName("ynivnbmtltlofstl")
    public suspend fun contactDetails(`value`: ContactDetailsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactDetails = mapped
    }

    /**
     * @param argument Contact details for notification and shipping.
     */
    @JvmName("lytytwjrberlxfnl")
    public suspend fun contactDetails(argument: suspend ContactDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ContactDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactDetails = mapped
    }

    /**
     * @param value Details of the data to be exported from azure.
     */
    @JvmName("rhucvejkfxogjmnw")
    public suspend fun dataExportDetails(`value`: List<DataExportDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataExportDetails = mapped
    }

    /**
     * @param argument Details of the data to be exported from azure.
     */
    @JvmName("gxpqcxtspfcdwuhw")
    public suspend fun dataExportDetails(argument: List<suspend DataExportDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataExportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataExportDetails = mapped
    }

    /**
     * @param argument Details of the data to be exported from azure.
     */
    @JvmName("itqlygbgpakxlffa")
    public suspend fun dataExportDetails(vararg argument: suspend DataExportDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataExportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataExportDetails = mapped
    }

    /**
     * @param argument Details of the data to be exported from azure.
     */
    @JvmName("gyakrekainsvkdsk")
    public suspend fun dataExportDetails(argument: suspend DataExportDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataExportDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataExportDetails = mapped
    }

    /**
     * @param values Details of the data to be exported from azure.
     */
    @JvmName("wjkwpkbkomuqiknd")
    public suspend fun dataExportDetails(vararg values: DataExportDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataExportDetails = mapped
    }

    /**
     * @param value Details of the data to be imported into azure.
     */
    @JvmName("cafchquueffklwen")
    public suspend fun dataImportDetails(`value`: List<DataImportDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataImportDetails = mapped
    }

    /**
     * @param argument Details of the data to be imported into azure.
     */
    @JvmName("ddemnibakafyygbd")
    public suspend fun dataImportDetails(argument: List<suspend DataImportDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataImportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataImportDetails = mapped
    }

    /**
     * @param argument Details of the data to be imported into azure.
     */
    @JvmName("bfwbgvrleknvfnnv")
    public suspend fun dataImportDetails(vararg argument: suspend DataImportDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataImportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataImportDetails = mapped
    }

    /**
     * @param argument Details of the data to be imported into azure.
     */
    @JvmName("jcfvrqsaljiwyjun")
    public suspend fun dataImportDetails(argument: suspend DataImportDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataImportDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataImportDetails = mapped
    }

    /**
     * @param values Details of the data to be imported into azure.
     */
    @JvmName("aayhxmngxfxaxhey")
    public suspend fun dataImportDetails(vararg values: DataImportDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataImportDetails = mapped
    }

    /**
     * @param value Flag to indicate if disk manifest should be backed-up in the Storage Account.
     */
    @JvmName("qwjltjxcnwtareyg")
    public suspend fun enableManifestBackup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableManifestBackup = mapped
    }

    /**
     * @param value The expected size of the data, which needs to be transferred in this job, in terabytes.
     */
    @JvmName("ekfmydhudbuphlll")
    public suspend fun expectedDataSizeInTeraBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedDataSizeInTeraBytes = mapped
    }

    /**
     * @param value Contains the map of disk serial number to the disk details for import jobs.
     */
    @JvmName("nlecnbbeknnknaxk")
    public suspend fun importDiskDetailsCollection(`value`: Map<String, ImportDiskDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importDiskDetailsCollection = mapped
    }

    /**
     * @param argument Contains the map of disk serial number to the disk details for import jobs.
     */
    @JvmName("hewnjoyjmlsghifc")
    public suspend fun importDiskDetailsCollection(vararg argument: Pair<String, suspend ImportDiskDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ImportDiskDetailsArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.importDiskDetailsCollection = mapped
    }

    /**
     * @param values Contains the map of disk serial number to the disk details for import jobs.
     */
    @JvmName("cfabtbafxendkdka")
    public fun importDiskDetailsCollection(vararg values: Pair<String, ImportDiskDetailsArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.importDiskDetailsCollection = mapped
    }

    /**
     * @param value Indicates the type of job details.
     * Expected value is 'DataBoxCustomerDisk'.
     */
    @JvmName("fiodcvtbqqcnbskq")
    public suspend fun jobDetailsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobDetailsType = mapped
    }

    /**
     * @param value Details about which key encryption type is being used.
     */
    @JvmName("mcqjioesispfbkyk")
    public suspend fun keyEncryptionKey(`value`: KeyEncryptionKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKey = mapped
    }

    /**
     * @param argument Details about which key encryption type is being used.
     */
    @JvmName("iirdalbleetyiabn")
    public suspend fun keyEncryptionKey(argument: suspend KeyEncryptionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = KeyEncryptionKeyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyEncryptionKey = mapped
    }

    /**
     * @param value Preferences for the order.
     */
    @JvmName("fdelwphfstdtbnpj")
    public suspend fun preferences(`value`: PreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferences = mapped
    }

    /**
     * @param argument Preferences for the order.
     */
    @JvmName("dfikvjjxeeisnkmh")
    public suspend fun preferences(argument: suspend PreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = PreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.preferences = mapped
    }

    /**
     * @param value Return package shipping details.
     */
    @JvmName("gnbhhjqemgroofwa")
    public suspend fun returnToCustomerPackageDetails(`value`: PackageCarrierDetailsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.returnToCustomerPackageDetails = mapped
    }

    /**
     * @param argument Return package shipping details.
     */
    @JvmName("idwwbqvwetucrcxl")
    public suspend fun returnToCustomerPackageDetails(argument: suspend PackageCarrierDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = PackageCarrierDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.returnToCustomerPackageDetails = mapped
    }

    /**
     * @param value Optional Reverse Shipping details for order.
     */
    @JvmName("wbetpheobpnrquff")
    public suspend fun reverseShippingDetails(`value`: ReverseShippingDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reverseShippingDetails = mapped
    }

    /**
     * @param argument Optional Reverse Shipping details for order.
     */
    @JvmName("obyvemcrhxjbbwgf")
    public suspend fun reverseShippingDetails(argument: suspend ReverseShippingDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ReverseShippingDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reverseShippingDetails = mapped
    }

    /**
     * @param value Shipping address of the customer.
     */
    @JvmName("buvcebssjkehlnwp")
    public suspend fun shippingAddress(`value`: ShippingAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shippingAddress = mapped
    }

    /**
     * @param argument Shipping address of the customer.
     */
    @JvmName("gdwaewdpirgxefwr")
    public suspend fun shippingAddress(argument: suspend ShippingAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ShippingAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shippingAddress = mapped
    }

    internal fun build(): DataBoxCustomerDiskJobDetailsArgs = DataBoxCustomerDiskJobDetailsArgs(
        contactDetails = contactDetails ?: throw PulumiNullFieldException("contactDetails"),
        dataExportDetails = dataExportDetails,
        dataImportDetails = dataImportDetails,
        enableManifestBackup = enableManifestBackup,
        expectedDataSizeInTeraBytes = expectedDataSizeInTeraBytes,
        importDiskDetailsCollection = importDiskDetailsCollection,
        jobDetailsType = jobDetailsType ?: throw PulumiNullFieldException("jobDetailsType"),
        keyEncryptionKey = keyEncryptionKey,
        preferences = preferences,
        returnToCustomerPackageDetails = returnToCustomerPackageDetails ?: throw
            PulumiNullFieldException("returnToCustomerPackageDetails"),
        reverseShippingDetails = reverseShippingDetails,
        shippingAddress = shippingAddress,
    )
}
