@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.FilterFileDetailsArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.FilterFileType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the filter files to be used for data transfer.
 * @property filterFilePath Path of the file that contains the details of all items to transfer.
 * @property filterFileType Type of the filter file.
 */
public data class FilterFileDetailsArgs(
    public val filterFilePath: Output<String>,
    public val filterFileType: Output<Either<String, FilterFileType>>,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.FilterFileDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.FilterFileDetailsArgs =
        com.pulumi.azurenative.databox.inputs.FilterFileDetailsArgs.builder()
            .filterFilePath(filterFilePath.applyValue({ args0 -> args0 }))
            .filterFileType(
                filterFileType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [FilterFileDetailsArgs].
 */
@PulumiTagMarker
public class FilterFileDetailsArgsBuilder internal constructor() {
    private var filterFilePath: Output<String>? = null

    private var filterFileType: Output<Either<String, FilterFileType>>? = null

    /**
     * @param value Path of the file that contains the details of all items to transfer.
     */
    @JvmName("exgifwnysfwrvddj")
    public suspend fun filterFilePath(`value`: Output<String>) {
        this.filterFilePath = value
    }

    /**
     * @param value Type of the filter file.
     */
    @JvmName("xkkbmdryvnnwknpj")
    public suspend fun filterFileType(`value`: Output<Either<String, FilterFileType>>) {
        this.filterFileType = value
    }

    /**
     * @param value Path of the file that contains the details of all items to transfer.
     */
    @JvmName("ycbjmbrcjspkavrh")
    public suspend fun filterFilePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterFilePath = mapped
    }

    /**
     * @param value Type of the filter file.
     */
    @JvmName("pkdotvbgltlkedxg")
    public suspend fun filterFileType(`value`: Either<String, FilterFileType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterFileType = mapped
    }

    /**
     * @param value Type of the filter file.
     */
    @JvmName("qdjddbafbydftcan")
    public fun filterFileType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FilterFileType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterFileType = mapped
    }

    /**
     * @param value Type of the filter file.
     */
    @JvmName("wtmgtaxjhrlcphts")
    public fun filterFileType(`value`: FilterFileType) {
        val toBeMapped = Either.ofRight<String, FilterFileType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterFileType = mapped
    }

    internal fun build(): FilterFileDetailsArgs = FilterFileDetailsArgs(
        filterFilePath = filterFilePath ?: throw PulumiNullFieldException("filterFilePath"),
        filterFileType = filterFileType ?: throw PulumiNullFieldException("filterFileType"),
    )
}
