@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.KeyEncryptionKeyArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.KekType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Encryption key containing details about key to encrypt different keys.
 * @property identityProperties Managed identity properties used for key encryption.
 * @property kekType Type of encryption key used for key encryption.
 * @property kekUrl Key encryption key. It is required in case of Customer managed KekType.
 * @property kekVaultResourceID Kek vault resource id. It is required in case of Customer managed KekType.
 */
public data class KeyEncryptionKeyArgs(
    public val identityProperties: Output<IdentityPropertiesArgs>? = null,
    public val kekType: Output<Either<String, KekType>>,
    public val kekUrl: Output<String>? = null,
    public val kekVaultResourceID: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.KeyEncryptionKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.KeyEncryptionKeyArgs =
        com.pulumi.azurenative.databox.inputs.KeyEncryptionKeyArgs.builder()
            .identityProperties(
                identityProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kekType(
                kekType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kekUrl(kekUrl?.applyValue({ args0 -> args0 }))
            .kekVaultResourceID(kekVaultResourceID?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyEncryptionKeyArgs].
 */
@PulumiTagMarker
public class KeyEncryptionKeyArgsBuilder internal constructor() {
    private var identityProperties: Output<IdentityPropertiesArgs>? = null

    private var kekType: Output<Either<String, KekType>>? = null

    private var kekUrl: Output<String>? = null

    private var kekVaultResourceID: Output<String>? = null

    /**
     * @param value Managed identity properties used for key encryption.
     */
    @JvmName("tnnwnntkittyxvgn")
    public suspend fun identityProperties(`value`: Output<IdentityPropertiesArgs>) {
        this.identityProperties = value
    }

    /**
     * @param value Type of encryption key used for key encryption.
     */
    @JvmName("fwmjihrqtjrilcjb")
    public suspend fun kekType(`value`: Output<Either<String, KekType>>) {
        this.kekType = value
    }

    /**
     * @param value Key encryption key. It is required in case of Customer managed KekType.
     */
    @JvmName("bpmfprgdkujapbtt")
    public suspend fun kekUrl(`value`: Output<String>) {
        this.kekUrl = value
    }

    /**
     * @param value Kek vault resource id. It is required in case of Customer managed KekType.
     */
    @JvmName("ppxvqxhapkgwrooo")
    public suspend fun kekVaultResourceID(`value`: Output<String>) {
        this.kekVaultResourceID = value
    }

    /**
     * @param value Managed identity properties used for key encryption.
     */
    @JvmName("pgubjwmrswpknlkc")
    public suspend fun identityProperties(`value`: IdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProperties = mapped
    }

    /**
     * @param argument Managed identity properties used for key encryption.
     */
    @JvmName("wpowtbkukfnkecuo")
    public suspend fun identityProperties(argument: suspend IdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identityProperties = mapped
    }

    /**
     * @param value Type of encryption key used for key encryption.
     */
    @JvmName("bpqovctudpwijqgc")
    public suspend fun kekType(`value`: Either<String, KekType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kekType = mapped
    }

    /**
     * @param value Type of encryption key used for key encryption.
     */
    @JvmName("tvwtyqwgybbusqel")
    public fun kekType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KekType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kekType = mapped
    }

    /**
     * @param value Type of encryption key used for key encryption.
     */
    @JvmName("yfchfjgdcuxjfbpn")
    public fun kekType(`value`: KekType) {
        val toBeMapped = Either.ofRight<String, KekType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kekType = mapped
    }

    /**
     * @param value Key encryption key. It is required in case of Customer managed KekType.
     */
    @JvmName("qdfctqerdfdnusem")
    public suspend fun kekUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kekUrl = mapped
    }

    /**
     * @param value Kek vault resource id. It is required in case of Customer managed KekType.
     */
    @JvmName("uvjdxsfibofapjhy")
    public suspend fun kekVaultResourceID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kekVaultResourceID = mapped
    }

    internal fun build(): KeyEncryptionKeyArgs = KeyEncryptionKeyArgs(
        identityProperties = identityProperties,
        kekType = kekType ?: throw PulumiNullFieldException("kekType"),
        kekUrl = kekUrl,
        kekVaultResourceID = kekVaultResourceID,
    )
}
