@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.TransferConfigurationArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.TransferConfigurationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration for defining the transfer of data.
 * @property transferAllDetails Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll
 * @property transferConfigurationType Type of the configuration for transfer.
 * @property transferFilterDetails Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter.
 */
public data class TransferConfigurationArgs(
    public val transferAllDetails: Output<TransferConfigurationTransferAllDetailsArgs>? = null,
    public val transferConfigurationType: Output<Either<String, TransferConfigurationType>>,
    public val transferFilterDetails: Output<TransferConfigurationTransferFilterDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.TransferConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.TransferConfigurationArgs =
        com.pulumi.azurenative.databox.inputs.TransferConfigurationArgs.builder()
            .transferAllDetails(
                transferAllDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .transferConfigurationType(
                transferConfigurationType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .transferFilterDetails(
                transferFilterDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TransferConfigurationArgs].
 */
@PulumiTagMarker
public class TransferConfigurationArgsBuilder internal constructor() {
    private var transferAllDetails: Output<TransferConfigurationTransferAllDetailsArgs>? = null

    private var transferConfigurationType: Output<Either<String, TransferConfigurationType>>? = null

    private var transferFilterDetails: Output<TransferConfigurationTransferFilterDetailsArgs>? = null

    /**
     * @param value Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll
     */
    @JvmName("roqrhbfpgxesfdhp")
    public suspend fun transferAllDetails(`value`: Output<TransferConfigurationTransferAllDetailsArgs>) {
        this.transferAllDetails = value
    }

    /**
     * @param value Type of the configuration for transfer.
     */
    @JvmName("ybhtfhdjmetnaguu")
    public suspend fun transferConfigurationType(`value`: Output<Either<String, TransferConfigurationType>>) {
        this.transferConfigurationType = value
    }

    /**
     * @param value Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter.
     */
    @JvmName("umfxgvinpolscyaa")
    public suspend fun transferFilterDetails(`value`: Output<TransferConfigurationTransferFilterDetailsArgs>) {
        this.transferFilterDetails = value
    }

    /**
     * @param value Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll
     */
    @JvmName("jmncadaoopokpfdk")
    public suspend fun transferAllDetails(`value`: TransferConfigurationTransferAllDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transferAllDetails = mapped
    }

    /**
     * @param argument Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll
     */
    @JvmName("obqlxkmyvsxghxco")
    public suspend fun transferAllDetails(argument: suspend TransferConfigurationTransferAllDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = TransferConfigurationTransferAllDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.transferAllDetails = mapped
    }

    /**
     * @param value Type of the configuration for transfer.
     */
    @JvmName("eeebmqboeajouxho")
    public suspend fun transferConfigurationType(`value`: Either<String, TransferConfigurationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transferConfigurationType = mapped
    }

    /**
     * @param value Type of the configuration for transfer.
     */
    @JvmName("mkxxeqpajlxpvhvx")
    public fun transferConfigurationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TransferConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transferConfigurationType = mapped
    }

    /**
     * @param value Type of the configuration for transfer.
     */
    @JvmName("tgwtukajpkchmvpk")
    public fun transferConfigurationType(`value`: TransferConfigurationType) {
        val toBeMapped = Either.ofRight<String, TransferConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transferConfigurationType = mapped
    }

    /**
     * @param value Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter.
     */
    @JvmName("yrvrgoieorodcbga")
    public suspend fun transferFilterDetails(`value`: TransferConfigurationTransferFilterDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transferFilterDetails = mapped
    }

    /**
     * @param argument Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter.
     */
    @JvmName("xfpmutrjdhdgljiy")
    public suspend fun transferFilterDetails(argument: suspend TransferConfigurationTransferFilterDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = TransferConfigurationTransferFilterDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.transferFilterDetails = mapped
    }

    internal fun build(): TransferConfigurationArgs = TransferConfigurationArgs(
        transferAllDetails = transferAllDetails,
        transferConfigurationType = transferConfigurationType ?: throw
            PulumiNullFieldException("transferConfigurationType"),
        transferFilterDetails = transferFilterDetails,
    )
}
