@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.TransferConfigurationTransferAllDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll
 * @property include Details to transfer all data.
 */
public data class TransferConfigurationTransferAllDetailsArgs(
    public val include: Output<TransferAllDetailsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.databox.inputs.TransferConfigurationTransferAllDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.TransferConfigurationTransferAllDetailsArgs =
        com.pulumi.azurenative.databox.inputs.TransferConfigurationTransferAllDetailsArgs.builder()
            .include(include?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TransferConfigurationTransferAllDetailsArgs].
 */
@PulumiTagMarker
public class TransferConfigurationTransferAllDetailsArgsBuilder internal constructor() {
    private var include: Output<TransferAllDetailsArgs>? = null

    /**
     * @param value Details to transfer all data.
     */
    @JvmName("nlmtcfpfnfbjncaf")
    public suspend fun include(`value`: Output<TransferAllDetailsArgs>) {
        this.include = value
    }

    /**
     * @param value Details to transfer all data.
     */
    @JvmName("cqxqalogepuxpaxl")
    public suspend fun include(`value`: TransferAllDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.include = mapped
    }

    /**
     * @param argument Details to transfer all data.
     */
    @JvmName("wdpsaqnitxxjdwmf")
    public suspend fun include(argument: suspend TransferAllDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = TransferAllDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.include = mapped
    }

    internal fun build(): TransferConfigurationTransferAllDetailsArgs =
        TransferConfigurationTransferAllDetailsArgs(
            include = include,
        )
}
