@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.UserAssignedPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User assigned identity properties.
 * @property resourceId Arm resource id for user assigned identity to be used to fetch MSI token.
 */
public data class UserAssignedPropertiesArgs(
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.UserAssignedPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.UserAssignedPropertiesArgs =
        com.pulumi.azurenative.databox.inputs.UserAssignedPropertiesArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAssignedPropertiesArgs].
 */
@PulumiTagMarker
public class UserAssignedPropertiesArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    /**
     * @param value Arm resource id for user assigned identity to be used to fetch MSI token.
     */
    @JvmName("nknxdtjmbevcikca")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Arm resource id for user assigned identity to be used to fetch MSI token.
     */
    @JvmName("dnpgqxhlirmfpddd")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): UserAssignedPropertiesArgs = UserAssignedPropertiesArgs(
        resourceId = resourceId,
    )
}
