@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Credential details of the account.
 * @property accountConnectionString Connection string of the account endpoint to use the account as a storage endpoint on the device.
 * @property accountName Name of the account.
 * @property dataAccountType Type of the account.
 * @property shareCredentialDetails Per share level unencrypted access credentials.
 */
public data class AccountCredentialDetailsResponse(
    public val accountConnectionString: String,
    public val accountName: String,
    public val dataAccountType: String,
    public val shareCredentialDetails: List<ShareCredentialDetailsResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.AccountCredentialDetailsResponse): AccountCredentialDetailsResponse = AccountCredentialDetailsResponse(
            accountConnectionString = javaType.accountConnectionString(),
            accountName = javaType.accountName(),
            dataAccountType = javaType.dataAccountType(),
            shareCredentialDetails = javaType.shareCredentialDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.ShareCredentialDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
