@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Network Adapter configuration of a DataBox.
 * @property macAddress Mac Address.
 * @property name Name of the network.
 */
public data class ApplianceNetworkConfigurationResponse(
    public val macAddress: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.ApplianceNetworkConfigurationResponse): ApplianceNetworkConfigurationResponse = ApplianceNetworkConfigurationResponse(
            macAddress = javaType.macAddress(),
            name = javaType.name(),
        )
    }
}
