@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Provides additional information about an http error response.
 * @property additionalInfo Gets or sets additional error info.
 * @property code Error code.
 * @property details Gets or sets details for the error.
 * @property message The error message parsed from the body of the http error response.
 * @property target Gets or sets the target of the error.
 */
public data class CloudErrorResponse(
    public val additionalInfo: List<AdditionalErrorInfoResponse>,
    public val code: String? = null,
    public val details: List<CloudErrorResponse>,
    public val message: String? = null,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.CloudErrorResponse): CloudErrorResponse = CloudErrorResponse(
            additionalInfo = javaType.additionalInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.AdditionalErrorInfoResponse.Companion.toKotlin(args0)
                })
            }),
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.CloudErrorResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
