@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Contact Details.
 * @property contactName Contact name of the person.
 * @property emailList List of Email-ids to be notified about job progress.
 * @property mobile Mobile number of the contact person.
 * @property notificationPreference Notification preference for a job stage.
 * @property phone Phone number of the contact person.
 * @property phoneExtension Phone extension number of the contact person.
 */
public data class ContactDetailsResponse(
    public val contactName: String,
    public val emailList: List<String>,
    public val mobile: String? = null,
    public val notificationPreference: List<NotificationPreferenceResponse>? = null,
    public val phone: String,
    public val phoneExtension: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.ContactDetailsResponse): ContactDetailsResponse = ContactDetailsResponse(
            contactName = javaType.contactName(),
            emailList = javaType.emailList().map({ args0 -> args0 }),
            mobile = javaType.mobile().map({ args0 -> args0 }).orElse(null),
            notificationPreference = javaType.notificationPreference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.NotificationPreferenceResponse.Companion.toKotlin(args0)
                })
            }),
            phone = javaType.phone(),
            phoneExtension = javaType.phoneExtension().map({ args0 -> args0 }).orElse(null),
        )
    }
}
