@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The secrets related to customer disk job.
 * @property carrierAccountNumber Carrier Account Number of the customer
 * @property dcAccessSecurityCode Dc Access Security Code for Customer Managed Shipping
 * @property diskSecrets Contains the list of secrets object for that device.
 * @property error Error while fetching the secrets.
 * @property jobSecretsType Used to indicate what type of job secrets object.
 * Expected value is 'DataBoxCustomerDisk'.
 */
public data class CustomerDiskJobSecretsResponse(
    public val carrierAccountNumber: String,
    public val dcAccessSecurityCode: DcAccessSecurityCodeResponse,
    public val diskSecrets: List<DiskSecretResponse>,
    public val error: CloudErrorResponse,
    public val jobSecretsType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.CustomerDiskJobSecretsResponse): CustomerDiskJobSecretsResponse = CustomerDiskJobSecretsResponse(
            carrierAccountNumber = javaType.carrierAccountNumber(),
            dcAccessSecurityCode = javaType.dcAccessSecurityCode().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.DcAccessSecurityCodeResponse.Companion.toKotlin(args0)
            }),
            diskSecrets = javaType.diskSecrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.DiskSecretResponse.Companion.toKotlin(args0)
                })
            }),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.CloudErrorResponse.Companion.toKotlin(args0)
            }),
            jobSecretsType = javaType.jobSecretsType(),
        )
    }
}
