@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Copy log details for a storage account of a DataBox job
 * @property accountName Account name.
 * @property copyLogDetailsType Indicates the type of job details.
 * Expected value is 'DataBox'.
 * @property copyLogLink Link for copy logs.
 * @property copyVerboseLogLink Link for copy verbose logs. This will be set only when LogCollectionLevel is set to Verbose.
 */
public data class DataBoxAccountCopyLogDetailsResponse(
    public val accountName: String,
    public val copyLogDetailsType: String,
    public val copyLogLink: String,
    public val copyVerboseLogLink: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataBoxAccountCopyLogDetailsResponse): DataBoxAccountCopyLogDetailsResponse = DataBoxAccountCopyLogDetailsResponse(
            accountName = javaType.accountName(),
            copyLogDetailsType = javaType.copyLogDetailsType(),
            copyLogLink = javaType.copyLogLink(),
            copyVerboseLogLink = javaType.copyVerboseLogLink(),
        )
    }
}
