@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Copy Log Details for a disk
 * @property copyLogDetailsType Indicates the type of job details.
 * Expected value is 'DataBoxDisk'.
 * @property diskSerialNumber Disk Serial Number.
 * @property errorLogLink Link for copy error logs.
 * @property verboseLogLink Link for copy verbose logs.
 */
public data class DataBoxDiskCopyLogDetailsResponse(
    public val copyLogDetailsType: String,
    public val diskSerialNumber: String,
    public val errorLogLink: String,
    public val verboseLogLink: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataBoxDiskCopyLogDetailsResponse): DataBoxDiskCopyLogDetailsResponse = DataBoxDiskCopyLogDetailsResponse(
            copyLogDetailsType = javaType.copyLogDetailsType(),
            diskSerialNumber = javaType.diskSerialNumber(),
            errorLogLink = javaType.errorLogLink(),
            verboseLogLink = javaType.verboseLogLink(),
        )
    }
}
