@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The secrets related to disk job.
 * @property dcAccessSecurityCode Dc Access Security Code for Customer Managed Shipping
 * @property diskSecrets Contains the list of secrets object for that device.
 * @property error Error while fetching the secrets.
 * @property isPasskeyUserDefined Whether passkey was provided by user.
 * @property jobSecretsType Used to indicate what type of job secrets object.
 * Expected value is 'DataBoxDisk'.
 * @property passKey PassKey for the disk Job.
 */
public data class DataBoxDiskJobSecretsResponse(
    public val dcAccessSecurityCode: DcAccessSecurityCodeResponse,
    public val diskSecrets: List<DiskSecretResponse>,
    public val error: CloudErrorResponse,
    public val isPasskeyUserDefined: Boolean,
    public val jobSecretsType: String,
    public val passKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataBoxDiskJobSecretsResponse): DataBoxDiskJobSecretsResponse = DataBoxDiskJobSecretsResponse(
            dcAccessSecurityCode = javaType.dcAccessSecurityCode().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.DcAccessSecurityCodeResponse.Companion.toKotlin(args0)
            }),
            diskSecrets = javaType.diskSecrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.DiskSecretResponse.Companion.toKotlin(args0)
                })
            }),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.CloudErrorResponse.Companion.toKotlin(args0)
            }),
            isPasskeyUserDefined = javaType.isPasskeyUserDefined(),
            jobSecretsType = javaType.jobSecretsType(),
            passKey = javaType.passKey(),
        )
    }
}
