@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The secrets related to a databox heavy job.
 * @property cabinetPodSecrets Contains the list of secret objects for a databox heavy job.
 * @property dcAccessSecurityCode Dc Access Security Code for Customer Managed Shipping
 * @property error Error while fetching the secrets.
 * @property jobSecretsType Used to indicate what type of job secrets object.
 * Expected value is 'DataBoxHeavy'.
 */
public data class DataBoxHeavyJobSecretsResponse(
    public val cabinetPodSecrets: List<DataBoxHeavySecretResponse>,
    public val dcAccessSecurityCode: DcAccessSecurityCodeResponse,
    public val error: CloudErrorResponse,
    public val jobSecretsType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataBoxHeavyJobSecretsResponse): DataBoxHeavyJobSecretsResponse = DataBoxHeavyJobSecretsResponse(
            cabinetPodSecrets = javaType.cabinetPodSecrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.DataBoxHeavySecretResponse.Companion.toKotlin(args0)
                })
            }),
            dcAccessSecurityCode = javaType.dcAccessSecurityCode().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.DcAccessSecurityCodeResponse.Companion.toKotlin(args0)
            }),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.CloudErrorResponse.Companion.toKotlin(args0)
            }),
            jobSecretsType = javaType.jobSecretsType(),
        )
    }
}
