@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Databox Job Details
 * @property actions Available actions on the job.
 * @property chainOfCustodySasKey Shared access key to download the chain of custody logs
 * @property contactDetails Contact details for notification and shipping.
 * @property copyLogDetails List of copy log details.
 * @property copyProgress Copy progress per storage account.
 * @property dataCenterCode DataCenter code.
 * @property dataExportDetails Details of the data to be exported from azure.
 * @property dataImportDetails Details of the data to be imported into azure.
 * @property datacenterAddress Datacenter address to ship to, for the given sku and storage location.
 * @property deliveryPackage Delivery package shipping details.
 * @property deviceErasureDetails Holds device data erasure details
 * @property devicePassword Set Device password for unlocking Databox. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
 * @property expectedDataSizeInTeraBytes The expected size of the data, which needs to be transferred in this job, in terabytes.
 * @property jobDetailsType Indicates the type of job details.
 * Expected value is 'DataBox'.
 * @property jobStages List of stages that run in the job.
 * @property keyEncryptionKey Details about which key encryption type is being used.
 * @property lastMitigationActionOnJob Last mitigation action performed on the job.
 * @property preferences Preferences for the order.
 * @property returnPackage Return package shipping details.
 * @property reverseShipmentLabelSasKey Shared access key to download the return shipment label
 * @property reverseShippingDetails Optional Reverse Shipping details for order.
 * @property shippingAddress Shipping address of the customer.
 */
public data class DataBoxJobDetailsResponse(
    public val actions: List<String>,
    public val chainOfCustodySasKey: String,
    public val contactDetails: ContactDetailsResponse,
    public val copyLogDetails: List<Any>,
    public val copyProgress: List<CopyProgressResponse>,
    public val dataCenterCode: String,
    public val dataExportDetails: List<DataExportDetailsResponse>? = null,
    public val dataImportDetails: List<DataImportDetailsResponse>? = null,
    public val datacenterAddress: Either<DatacenterAddressInstructionResponseResponse, DatacenterAddressLocationResponseResponse>,
    public val deliveryPackage: PackageShippingDetailsResponse,
    public val deviceErasureDetails: DeviceErasureDetailsResponse,
    public val devicePassword: String? = null,
    public val expectedDataSizeInTeraBytes: Int? = null,
    public val jobDetailsType: String,
    public val jobStages: List<JobStagesResponse>,
    public val keyEncryptionKey: KeyEncryptionKeyResponse? = null,
    public val lastMitigationActionOnJob: LastMitigationActionOnJobResponse,
    public val preferences: PreferencesResponse? = null,
    public val returnPackage: PackageShippingDetailsResponse,
    public val reverseShipmentLabelSasKey: String,
    public val reverseShippingDetails: ReverseShippingDetailsResponse? = null,
    public val shippingAddress: ShippingAddressResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataBoxJobDetailsResponse): DataBoxJobDetailsResponse = DataBoxJobDetailsResponse(
            actions = javaType.actions().map({ args0 -> args0 }),
            chainOfCustodySasKey = javaType.chainOfCustodySasKey(),
            contactDetails = javaType.contactDetails().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.ContactDetailsResponse.Companion.toKotlin(args0)
            }),
            copyLogDetails = javaType.copyLogDetails().map({ args0 -> args0 }),
            copyProgress = javaType.copyProgress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.CopyProgressResponse.Companion.toKotlin(args0)
                })
            }),
            dataCenterCode = javaType.dataCenterCode(),
            dataExportDetails = javaType.dataExportDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.DataExportDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            dataImportDetails = javaType.dataImportDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.DataImportDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            datacenterAddress = javaType.datacenterAddress().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.DatacenterAddressInstructionResponseResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.DatacenterAddressLocationResponseResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            deliveryPackage = javaType.deliveryPackage().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.PackageShippingDetailsResponse.Companion.toKotlin(args0)
            }),
            deviceErasureDetails = javaType.deviceErasureDetails().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.DeviceErasureDetailsResponse.Companion.toKotlin(args0)
            }),
            devicePassword = javaType.devicePassword().map({ args0 -> args0 }).orElse(null),
            expectedDataSizeInTeraBytes = javaType.expectedDataSizeInTeraBytes().map({ args0 ->
                args0
            }).orElse(null),
            jobDetailsType = javaType.jobDetailsType(),
            jobStages = javaType.jobStages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.JobStagesResponse.Companion.toKotlin(args0)
                })
            }),
            keyEncryptionKey = javaType.keyEncryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.KeyEncryptionKeyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastMitigationActionOnJob = javaType.lastMitigationActionOnJob().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.LastMitigationActionOnJobResponse.Companion.toKotlin(args0)
            }),
            preferences = javaType.preferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.PreferencesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            returnPackage = javaType.returnPackage().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.PackageShippingDetailsResponse.Companion.toKotlin(args0)
            }),
            reverseShipmentLabelSasKey = javaType.reverseShipmentLabelSasKey(),
            reverseShippingDetails = javaType.reverseShippingDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.ReverseShippingDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            shippingAddress = javaType.shippingAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.ShippingAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
