@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Details of the data to be used for exporting data from azure.
 * @property accountDetails Account details of the data to be transferred
 * @property logCollectionLevel Level of the logs to be collected.
 * @property transferConfiguration Configuration for the data transfer.
 */
public data class DataExportDetailsResponse(
    public val accountDetails: Either<ManagedDiskDetailsResponse, StorageAccountDetailsResponse>,
    public val logCollectionLevel: String? = null,
    public val transferConfiguration: TransferConfigurationResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataExportDetailsResponse): DataExportDetailsResponse = DataExportDetailsResponse(
            accountDetails = javaType.accountDetails().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.ManagedDiskDetailsResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.StorageAccountDetailsResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            logCollectionLevel = javaType.logCollectionLevel().map({ args0 -> args0 }).orElse(null),
            transferConfiguration = javaType.transferConfiguration().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.TransferConfigurationResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
