@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The secrets related to a databox job.
 * @property dcAccessSecurityCode Dc Access Security Code for Customer Managed Shipping
 * @property error Error while fetching the secrets.
 * @property jobSecretsType Used to indicate what type of job secrets object.
 * Expected value is 'DataBox'.
 * @property podSecrets Contains the list of secret objects for a job.
 */
public data class DataboxJobSecretsResponse(
    public val dcAccessSecurityCode: DcAccessSecurityCodeResponse,
    public val error: CloudErrorResponse,
    public val jobSecretsType: String,
    public val podSecrets: List<DataBoxSecretResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataboxJobSecretsResponse): DataboxJobSecretsResponse = DataboxJobSecretsResponse(
            dcAccessSecurityCode = javaType.dcAccessSecurityCode().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.DcAccessSecurityCodeResponse.Companion.toKotlin(args0)
            }),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.CloudErrorResponse.Companion.toKotlin(args0)
            }),
            jobSecretsType = javaType.jobSecretsType(),
            podSecrets = javaType.podSecrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.DataBoxSecretResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
