@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Device erasure details with erasure completion status and erasureordestructionlog sas key
 * @property deviceErasureStatus Holds the device erasure completion status
 * @property erasureOrDestructionCertificateSasKey Shared access key to download cleanup or destruction certificate for device
 */
public data class DeviceErasureDetailsResponse(
    public val deviceErasureStatus: String,
    public val erasureOrDestructionCertificateSasKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DeviceErasureDetailsResponse): DeviceErasureDetailsResponse = DeviceErasureDetailsResponse(
            deviceErasureStatus = javaType.deviceErasureStatus(),
            erasureOrDestructionCertificateSasKey = javaType.erasureOrDestructionCertificateSasKey(),
        )
    }
}
