@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Preferences related to the Encryption.
 * @property doubleEncryption Defines secondary layer of software-based encryption enablement.
 * @property hardwareEncryption Defines Hardware level encryption (Only for disk)
 */
public data class EncryptionPreferencesResponse(
    public val doubleEncryption: String? = null,
    public val hardwareEncryption: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.EncryptionPreferencesResponse): EncryptionPreferencesResponse = EncryptionPreferencesResponse(
            doubleEncryption = javaType.doubleEncryption().map({ args0 -> args0 }).orElse(null),
            hardwareEncryption = javaType.hardwareEncryption().map({ args0 -> args0 }).orElse(null),
        )
    }
}
