@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the filter files to be used for data transfer.
 * @property filterFilePath Path of the file that contains the details of all items to transfer.
 * @property filterFileType Type of the filter file.
 */
public data class FilterFileDetailsResponse(
    public val filterFilePath: String,
    public val filterFileType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.FilterFileDetailsResponse): FilterFileDetailsResponse = FilterFileDetailsResponse(
            filterFilePath = javaType.filterFilePath(),
            filterFileType = javaType.filterFileType(),
        )
    }
}
