@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed identity properties.
 * @property type Managed service identity type.
 * @property userAssigned User assigned identity properties.
 */
public data class IdentityPropertiesResponse(
    public val type: String? = null,
    public val userAssigned: UserAssignedPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.IdentityPropertiesResponse): IdentityPropertiesResponse = IdentityPropertiesResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssigned = javaType.userAssigned().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.UserAssignedPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
