@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Import disk details
 * @property backupManifestCloudPath Path to backed up manifest, only returned if enableManifestBackup is true.
 * @property bitLockerKey BitLocker key used to encrypt the disk.
 * @property manifestFile The relative path of the manifest file on the disk.
 * @property manifestHash The Base16-encoded MD5 hash of the manifest file on the disk.
 */
public data class ImportDiskDetailsResponse(
    public val backupManifestCloudPath: String,
    public val bitLockerKey: String,
    public val manifestFile: String,
    public val manifestHash: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.ImportDiskDetailsResponse): ImportDiskDetailsResponse = ImportDiskDetailsResponse(
            backupManifestCloudPath = javaType.backupManifestCloudPath(),
            bitLockerKey = javaType.bitLockerKey(),
            manifestFile = javaType.manifestFile(),
            manifestHash = javaType.manifestHash(),
        )
    }
}
