@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Job stages.
 * @property displayName Display name of the job stage.
 * @property jobStageDetails Job Stage Details
 * @property stageName Name of the job stage.
 * @property stageStatus Status of the job stage.
 * @property stageTime Time for the job stage in UTC ISO 8601 format.
 */
public data class JobStagesResponse(
    public val displayName: String,
    public val jobStageDetails: Any,
    public val stageName: String,
    public val stageStatus: String,
    public val stageTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.JobStagesResponse): JobStagesResponse = JobStagesResponse(
            displayName = javaType.displayName(),
            jobStageDetails = javaType.jobStageDetails(),
            stageName = javaType.stageName(),
            stageStatus = javaType.stageStatus(),
            stageTime = javaType.stageTime(),
        )
    }
}
