@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * List of unencrypted credentials for accessing device.
 * @property nextLink Link for the next set of unencrypted credentials.
 * @property value List of unencrypted credentials.
 */
public data class ListJobCredentialsResult(
    public val nextLink: String? = null,
    public val `value`: List<UnencryptedCredentialsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.ListJobCredentialsResult): ListJobCredentialsResult = ListJobCredentialsResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.UnencryptedCredentialsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
