@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the managed disks.
 * @property dataAccountType Account Type of the data to be transferred.
 * Expected value is 'ManagedDisk'.
 * @property resourceGroupId Resource Group Id of the compute disks.
 * @property stagingStorageAccountId Resource Id of the storage account that can be used to copy the vhd for staging.
 */
public data class ManagedDiskDetailsResponse(
    public val dataAccountType: String,
    public val resourceGroupId: String,
    public val stagingStorageAccountId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.ManagedDiskDetailsResponse): ManagedDiskDetailsResponse = ManagedDiskDetailsResponse(
            dataAccountType = javaType.dataAccountType(),
            resourceGroupId = javaType.resourceGroupId(),
            stagingStorageAccountId = javaType.stagingStorageAccountId(),
        )
    }
}
