@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Package carrier details.
 * @property carrierAccountNumber Carrier Account Number of customer for customer disk.
 * @property carrierName Name of the carrier.
 * @property trackingId Tracking Id of shipment.
 */
public data class PackageCarrierDetailsResponse(
    public val carrierAccountNumber: String? = null,
    public val carrierName: String? = null,
    public val trackingId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.PackageCarrierDetailsResponse): PackageCarrierDetailsResponse = PackageCarrierDetailsResponse(
            carrierAccountNumber = javaType.carrierAccountNumber().map({ args0 -> args0 }).orElse(null),
            carrierName = javaType.carrierName().map({ args0 -> args0 }).orElse(null),
            trackingId = javaType.trackingId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
