@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * package carrier info
 * @property carrierName Name of the carrier.
 * @property trackingId Tracking Id of shipment.
 */
public data class PackageCarrierInfoResponse(
    public val carrierName: String? = null,
    public val trackingId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.PackageCarrierInfoResponse): PackageCarrierInfoResponse = PackageCarrierInfoResponse(
            carrierName = javaType.carrierName().map({ args0 -> args0 }).orElse(null),
            trackingId = javaType.trackingId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
