@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * package shipping details
 * @property carrierName Name of the carrier.
 * @property trackingId Tracking Id of shipment.
 * @property trackingUrl Url where shipment can be tracked.
 */
public data class PackageShippingDetailsResponse(
    public val carrierName: String,
    public val trackingId: String,
    public val trackingUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.PackageShippingDetailsResponse): PackageShippingDetailsResponse = PackageShippingDetailsResponse(
            carrierName = javaType.carrierName(),
            trackingId = javaType.trackingId(),
            trackingUrl = javaType.trackingUrl(),
        )
    }
}
