@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Credential details of the shares in account.
 * @property password Password for the share.
 * @property shareName Name of the share.
 * @property shareType Type of the share.
 * @property supportedAccessProtocols Access protocols supported on the device.
 * @property userName User name for the share.
 */
public data class ShareCredentialDetailsResponse(
    public val password: String,
    public val shareName: String,
    public val shareType: String,
    public val supportedAccessProtocols: List<String>,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.ShareCredentialDetailsResponse): ShareCredentialDetailsResponse = ShareCredentialDetailsResponse(
            password = javaType.password(),
            shareName = javaType.shareName(),
            shareType = javaType.shareType(),
            supportedAccessProtocols = javaType.supportedAccessProtocols().map({ args0 -> args0 }),
            userName = javaType.userName(),
        )
    }
}
