@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Shipping address where customer wishes to receive the device.
 * @property addressType Type of address.
 * @property city Name of the City.
 * @property companyName Name of the company.
 * @property country Name of the Country.
 * @property postalCode Postal code.
 * @property skipAddressValidation Flag to indicate if customer has chosen to skip default address validation
 * @property stateOrProvince Name of the State or Province.
 * @property streetAddress1 Street Address line 1.
 * @property streetAddress2 Street Address line 2.
 * @property streetAddress3 Street Address line 3.
 * @property taxIdentificationNumber Tax Identification Number
 * @property zipExtendedCode Extended Zip Code.
 */
public data class ShippingAddressResponse(
    public val addressType: String? = null,
    public val city: String? = null,
    public val companyName: String? = null,
    public val country: String,
    public val postalCode: String? = null,
    public val skipAddressValidation: Boolean? = null,
    public val stateOrProvince: String? = null,
    public val streetAddress1: String,
    public val streetAddress2: String? = null,
    public val streetAddress3: String? = null,
    public val taxIdentificationNumber: String? = null,
    public val zipExtendedCode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.ShippingAddressResponse): ShippingAddressResponse = ShippingAddressResponse(
            addressType = javaType.addressType().map({ args0 -> args0 }).orElse(null),
            city = javaType.city().map({ args0 -> args0 }).orElse(null),
            companyName = javaType.companyName().map({ args0 -> args0 }).orElse(null),
            country = javaType.country(),
            postalCode = javaType.postalCode().map({ args0 -> args0 }).orElse(null),
            skipAddressValidation = javaType.skipAddressValidation().map({ args0 -> args0 }).orElse(null),
            stateOrProvince = javaType.stateOrProvince().map({ args0 -> args0 }).orElse(null),
            streetAddress1 = javaType.streetAddress1(),
            streetAddress2 = javaType.streetAddress2().map({ args0 -> args0 }).orElse(null),
            streetAddress3 = javaType.streetAddress3().map({ args0 -> args0 }).orElse(null),
            taxIdentificationNumber = javaType.taxIdentificationNumber().map({ args0 -> args0 }).orElse(null),
            zipExtendedCode = javaType.zipExtendedCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
