@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details of the filtering the transfer of data.
 * @property azureFileFilterDetails Filter details to transfer Azure files.
 * @property blobFilterDetails Filter details to transfer blobs.
 * @property dataAccountType Type of the account of data.
 * @property filterFileDetails Details of the filter files to be used for data transfer.
 */
public data class TransferFilterDetailsResponse(
    public val azureFileFilterDetails: AzureFileFilterDetailsResponse? = null,
    public val blobFilterDetails: BlobFilterDetailsResponse? = null,
    public val dataAccountType: String,
    public val filterFileDetails: List<FilterFileDetailsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.TransferFilterDetailsResponse): TransferFilterDetailsResponse = TransferFilterDetailsResponse(
            azureFileFilterDetails = javaType.azureFileFilterDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.AzureFileFilterDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            blobFilterDetails = javaType.blobFilterDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.BlobFilterDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataAccountType = javaType.dataAccountType(),
            filterFileDetails = javaType.filterFileDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.FilterFileDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
