@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Unencrypted credentials for accessing device.
 * @property jobName Name of the job.
 * @property jobSecrets Secrets related to this job.
 */
public data class UnencryptedCredentialsResponse(
    public val jobName: String,
    public val jobSecrets: Any,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.UnencryptedCredentialsResponse): UnencryptedCredentialsResponse = UnencryptedCredentialsResponse(
            jobName = javaType.jobName(),
            jobSecrets = javaType.jobSecrets(),
        )
    }
}
