@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ArcAddon].
 */
@PulumiTagMarker
public class ArcAddonResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ArcAddonArgs = ArcAddonArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ArcAddonArgsBuilder.() -> Unit) {
        val builder = ArcAddonArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ArcAddon {
        val builtJavaResource = com.pulumi.azurenative.databoxedge.ArcAddon(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ArcAddon(builtJavaResource)
    }
}

/**
 * Arc Addon.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### PutAddOns
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var arcAddon = new AzureNative.DataBoxEdge.ArcAddon("arcAddon", new()
 *     {
 *         AddonName = "arcName",
 *         DeviceName = "testedgedevice",
 *         Kind = "ArcForKubernetes",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         ResourceLocation = "EastUS",
 *         ResourceName = "testedgedevice",
 *         RoleName = "KubernetesRole",
 *         SubscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewArcAddon(ctx, "arcAddon", &databoxedge.ArcAddonArgs{
 * 			AddonName:         pulumi.String("arcName"),
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Kind:              pulumi.String("ArcForKubernetes"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			ResourceLocation:  pulumi.String("EastUS"),
 * 			ResourceName:      pulumi.String("testedgedevice"),
 * 			RoleName:          pulumi.String("KubernetesRole"),
 * 			SubscriptionId:    pulumi.String("4385cf00-2d3a-425a-832f-f4285b1c9dce"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.ArcAddon;
 * import com.pulumi.azurenative.databoxedge.ArcAddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var arcAddon = new ArcAddon("arcAddon", ArcAddonArgs.builder()
 *             .addonName("arcName")
 *             .deviceName("testedgedevice")
 *             .kind("ArcForKubernetes")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .resourceLocation("EastUS")
 *             .resourceName("testedgedevice")
 *             .roleName("KubernetesRole")
 *             .subscriptionId("4385cf00-2d3a-425a-832f-f4285b1c9dce")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:ArcAddon arcName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{roleName}/addons/{addonName}
 * ```
 */
public class ArcAddon internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.ArcAddon,
) : KotlinCustomResource(javaResource, ArcAddonMapper) {
    /**
     * Host OS supported by the Arc addon.
     */
    public val hostPlatform: Output<String>
        get() = javaResource.hostPlatform().applyValue({ args0 -> args0 })

    /**
     * Platform where the runtime is hosted.
     */
    public val hostPlatformType: Output<String>
        get() = javaResource.hostPlatformType().applyValue({ args0 -> args0 })

    /**
     * Addon type.
     * Expected value is 'ArcForKubernetes'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Addon Provisioning State
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Arc resource group name
     */
    public val resourceGroupName: Output<String>
        get() = javaResource.resourceGroupName().applyValue({ args0 -> args0 })

    /**
     * Arc resource location
     */
    public val resourceLocation: Output<String>
        get() = javaResource.resourceLocation().applyValue({ args0 -> args0 })

    /**
     * Arc resource Name
     */
    public val resourceName: Output<String>
        get() = javaResource.resourceName().applyValue({ args0 -> args0 })

    /**
     * Arc resource subscription Id
     */
    public val subscriptionId: Output<String>
        get() = javaResource.subscriptionId().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of Addon
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Arc resource version
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object ArcAddonMapper : ResourceMapper<ArcAddon> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.ArcAddon::class == javaResource::class

    override fun map(javaResource: Resource): ArcAddon = ArcAddon(
        javaResource as
            com.pulumi.azurenative.databoxedge.ArcAddon,
    )
}

/**
 * @see [ArcAddon].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ArcAddon].
 */
public suspend fun arcAddon(name: String, block: suspend ArcAddonResourceBuilder.() -> Unit): ArcAddon {
    val builder = ArcAddonResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ArcAddon].
 * @param name The _unique_ name of the resulting resource.
 */
public fun arcAddon(name: String): ArcAddon {
    val builder = ArcAddonResourceBuilder()
    builder.name(name)
    return builder.build()
}
