@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.ArcAddonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Arc Addon.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### PutAddOns
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var arcAddon = new AzureNative.DataBoxEdge.ArcAddon("arcAddon", new()
 *     {
 *         AddonName = "arcName",
 *         DeviceName = "testedgedevice",
 *         Kind = "ArcForKubernetes",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         ResourceLocation = "EastUS",
 *         ResourceName = "testedgedevice",
 *         RoleName = "KubernetesRole",
 *         SubscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewArcAddon(ctx, "arcAddon", &databoxedge.ArcAddonArgs{
 * 			AddonName:         pulumi.String("arcName"),
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Kind:              pulumi.String("ArcForKubernetes"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			ResourceLocation:  pulumi.String("EastUS"),
 * 			ResourceName:      pulumi.String("testedgedevice"),
 * 			RoleName:          pulumi.String("KubernetesRole"),
 * 			SubscriptionId:    pulumi.String("4385cf00-2d3a-425a-832f-f4285b1c9dce"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.ArcAddon;
 * import com.pulumi.azurenative.databoxedge.ArcAddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var arcAddon = new ArcAddon("arcAddon", ArcAddonArgs.builder()
 *             .addonName("arcName")
 *             .deviceName("testedgedevice")
 *             .kind("ArcForKubernetes")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .resourceLocation("EastUS")
 *             .resourceName("testedgedevice")
 *             .roleName("KubernetesRole")
 *             .subscriptionId("4385cf00-2d3a-425a-832f-f4285b1c9dce")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:ArcAddon arcName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{roleName}/addons/{addonName}
 * ```
 * @property addonName The addon name.
 * @property deviceName The device name.
 * @property kind Addon type.
 * Expected value is 'ArcForKubernetes'.
 * @property resourceGroupName The resource group name.
 * @property resourceLocation Arc resource location
 * @property resourceName Arc resource Name
 * @property roleName The role name.
 * @property subscriptionId Arc resource subscription Id
 */
public data class ArcAddonArgs(
    public val addonName: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceLocation: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val roleName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.ArcAddonArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.ArcAddonArgs =
        com.pulumi.azurenative.databoxedge.ArcAddonArgs.builder()
            .addonName(addonName?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceLocation(resourceLocation?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArcAddonArgs].
 */
@PulumiTagMarker
public class ArcAddonArgsBuilder internal constructor() {
    private var addonName: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceLocation: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var roleName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value The addon name.
     */
    @JvmName("ftlnvqnqvajtcith")
    public suspend fun addonName(`value`: Output<String>) {
        this.addonName = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("kpqqcppyoryrkusc")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Addon type.
     * Expected value is 'ArcForKubernetes'.
     */
    @JvmName("nvsbwipjhmojoyay")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("lttstlvhvremlyop")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Arc resource location
     */
    @JvmName("hyyfieqkjodgietl")
    public suspend fun resourceLocation(`value`: Output<String>) {
        this.resourceLocation = value
    }

    /**
     * @param value Arc resource Name
     */
    @JvmName("ismgcprcbyjohbxj")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The role name.
     */
    @JvmName("biwuhllyjjkuwybp")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value Arc resource subscription Id
     */
    @JvmName("kdlrfilydtwqwrmf")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The addon name.
     */
    @JvmName("kpkklukwjcyooely")
    public suspend fun addonName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonName = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("cclyxjqgcunuaqhb")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Addon type.
     * Expected value is 'ArcForKubernetes'.
     */
    @JvmName("wohrcdhexrdxckid")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("hymruwvoifemwhpb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Arc resource location
     */
    @JvmName("jgtxmoumoluusijj")
    public suspend fun resourceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLocation = mapped
    }

    /**
     * @param value Arc resource Name
     */
    @JvmName("koxhqmvlsrnvxkde")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("iuswjjloqqgceddv")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value Arc resource subscription Id
     */
    @JvmName("tvwkmuehnvrpolew")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): ArcAddonArgs = ArcAddonArgs(
        addonName = addonName,
        deviceName = deviceName,
        kind = kind,
        resourceGroupName = resourceGroupName,
        resourceLocation = resourceLocation,
        resourceName = resourceName,
        roleName = roleName,
        subscriptionId = subscriptionId,
    )
}
