@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.CloudEdgeManagementRoleArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.RoleStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The preview of Virtual Machine Cloud Management from the Azure supports deploying and managing VMs on your Azure Stack Edge device from Azure Portal.
 * For more information, refer to: https://docs.microsoft.com/en-us/azure/databox-online/azure-stack-edge-gpu-virtual-machine-overview
 * By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/ for additional details.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### RolePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudEdgeManagementRole = new AzureNative.DataBoxEdge.CloudEdgeManagementRole("cloudEdgeManagementRole", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         Name = "IoTRole1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewCloudEdgeManagementRole(ctx, "cloudEdgeManagementRole", &databoxedge.CloudEdgeManagementRoleArgs{
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("IoTRole1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.CloudEdgeManagementRole;
 * import com.pulumi.azurenative.databoxedge.CloudEdgeManagementRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudEdgeManagementRole = new CloudEdgeManagementRole("cloudEdgeManagementRole", CloudEdgeManagementRoleArgs.builder()
 *             .deviceName("testedgedevice")
 *             .name("IoTRole1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:CloudEdgeManagementRole IoTRole1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{name}
 * ```
 * @property deviceName The device name.
 * @property kind Role type.
 * Expected value is 'CloudEdgeManagement'.
 * @property name The role name.
 * @property resourceGroupName The resource group name.
 * @property roleStatus Role status.
 */
public data class CloudEdgeManagementRoleArgs(
    public val deviceName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val roleStatus: Output<Either<String, RoleStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.CloudEdgeManagementRoleArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.CloudEdgeManagementRoleArgs =
        com.pulumi.azurenative.databoxedge.CloudEdgeManagementRoleArgs.builder()
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .roleStatus(
                roleStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CloudEdgeManagementRoleArgs].
 */
@PulumiTagMarker
public class CloudEdgeManagementRoleArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var roleStatus: Output<Either<String, RoleStatus>>? = null

    /**
     * @param value The device name.
     */
    @JvmName("skjqnypiildagbem")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Role type.
     * Expected value is 'CloudEdgeManagement'.
     */
    @JvmName("leeddugqrockhfnl")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The role name.
     */
    @JvmName("anrgocngrnufodpa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("lrotcstqadohxkda")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Role status.
     */
    @JvmName("gdpxdkqtftmyokhw")
    public suspend fun roleStatus(`value`: Output<Either<String, RoleStatus>>) {
        this.roleStatus = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("xvaufbetheckrjxs")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Role type.
     * Expected value is 'CloudEdgeManagement'.
     */
    @JvmName("casugcmjeaeskwiw")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("osxdjevylnmixgho")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("bxtgmyjqixyqqftn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("eyxcojrmlhcthmgp")
    public suspend fun roleStatus(`value`: Either<String, RoleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("bljhdwsgaixdixau")
    public fun roleStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("tbbcvflyjodelyvd")
    public fun roleStatus(`value`: RoleStatus) {
        val toBeMapped = Either.ofRight<String, RoleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    internal fun build(): CloudEdgeManagementRoleArgs = CloudEdgeManagementRoleArgs(
        deviceName = deviceName,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        roleStatus = roleStatus,
    )
}
