@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.RefreshDetailsResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databoxedge.kotlin.outputs.RefreshDetailsResponse.Companion.toKotlin as refreshDetailsResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Container].
 */
@PulumiTagMarker
public class ContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContainerArgs = ContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContainerArgsBuilder.() -> Unit) {
        val builder = ContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Container {
        val builtJavaResource = com.pulumi.azurenative.databoxedge.Container(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Container(builtJavaResource)
    }
}

/**
 * Represents a container on the  Data Box Edge/Gateway device.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### ContainerPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var container = new AzureNative.DataBoxEdge.Container("container", new()
 *     {
 *         ContainerName = "blobcontainer1",
 *         DataFormat = AzureNative.DataBoxEdge.AzureContainerDataFormat.BlockBlob,
 *         DeviceName = "testedgedevice",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         StorageAccountName = "storageaccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewContainer(ctx, "container", &databoxedge.ContainerArgs{
 * 			ContainerName:      pulumi.String("blobcontainer1"),
 * 			DataFormat:         pulumi.String(databoxedge.AzureContainerDataFormatBlockBlob),
 * 			DeviceName:         pulumi.String("testedgedevice"),
 * 			ResourceGroupName:  pulumi.String("GroupForEdgeAutomation"),
 * 			StorageAccountName: pulumi.String("storageaccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.Container;
 * import com.pulumi.azurenative.databoxedge.ContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var container = new Container("container", ContainerArgs.builder()
 *             .containerName("blobcontainer1")
 *             .dataFormat("BlockBlob")
 *             .deviceName("testedgedevice")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .storageAccountName("storageaccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:Container blobcontainer-5e155efe /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/storageAccounts/{storageAccountName}/containers/{containerName}
 * ```
 */
public class Container internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.Container,
) : KotlinCustomResource(javaResource, ContainerMapper) {
    /**
     * Current status of the container.
     */
    public val containerStatus: Output<String>
        get() = javaResource.containerStatus().applyValue({ args0 -> args0 })

    /**
     * The UTC time when container got created.
     */
    public val createdDateTime: Output<String>
        get() = javaResource.createdDateTime().applyValue({ args0 -> args0 })

    /**
     * DataFormat for Container
     */
    public val dataFormat: Output<String>
        get() = javaResource.dataFormat().applyValue({ args0 -> args0 })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Details of the refresh job on this container.
     */
    public val refreshDetails: Output<RefreshDetailsResponse>
        get() = javaResource.refreshDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                refreshDetailsResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of Container
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContainerMapper : ResourceMapper<Container> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.Container::class == javaResource::class

    override fun map(javaResource: Resource): Container = Container(
        javaResource as
            com.pulumi.azurenative.databoxedge.Container,
    )
}

/**
 * @see [Container].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Container].
 */
public suspend fun container(name: String, block: suspend ContainerResourceBuilder.() -> Unit): Container {
    val builder = ContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Container].
 * @param name The _unique_ name of the resulting resource.
 */
public fun container(name: String): Container {
    val builder = ContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
