@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.IoTRoleArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.PlatformType
import com.pulumi.azurenative.databoxedge.kotlin.enums.RoleStatus
import com.pulumi.azurenative.databoxedge.kotlin.inputs.ComputeResourceArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.ComputeResourceArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.IoTDeviceInfoArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.IoTDeviceInfoArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.IoTEdgeAgentInfoArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.IoTEdgeAgentInfoArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.MountPointMapArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.MountPointMapArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Compute role.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### RolePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ioTRole = new AzureNative.DataBoxEdge.IoTRole("ioTRole", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         HostPlatform = AzureNative.DataBoxEdge.PlatformType.Linux,
 *         IoTDeviceDetails = new AzureNative.DataBoxEdge.Inputs.IoTDeviceInfoArgs
 *         {
 *             Authentication = new AzureNative.DataBoxEdge.Inputs.AuthenticationArgs
 *             {
 *                 SymmetricKey = new AzureNative.DataBoxEdge.Inputs.SymmetricKeyArgs
 *                 {
 *                     ConnectionString = new AzureNative.DataBoxEdge.Inputs.AsymmetricEncryptedSecretArgs
 *                     {
 *                         EncryptionAlgorithm = AzureNative.DataBoxEdge.EncryptionAlgorithm.AES256,
 *                         EncryptionCertThumbprint = "348586569999244",
 *                         Value = "Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotDevice;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>",
 *                     },
 *                 },
 *             },
 *             DeviceId = "iotdevice",
 *             IoTHostHub = "iothub.azure-devices.net",
 *         },
 *         IoTEdgeDeviceDetails = new AzureNative.DataBoxEdge.Inputs.IoTDeviceInfoArgs
 *         {
 *             Authentication = new AzureNative.DataBoxEdge.Inputs.AuthenticationArgs
 *             {
 *                 SymmetricKey = new AzureNative.DataBoxEdge.Inputs.SymmetricKeyArgs
 *                 {
 *                     ConnectionString = new AzureNative.DataBoxEdge.Inputs.AsymmetricEncryptedSecretArgs
 *                     {
 *                         EncryptionAlgorithm = AzureNative.DataBoxEdge.EncryptionAlgorithm.AES256,
 *                         EncryptionCertThumbprint = "1245475856069999244",
 *                         Value = "Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotEdge;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>",
 *                     },
 *                 },
 *             },
 *             DeviceId = "iotEdge",
 *             IoTHostHub = "iothub.azure-devices.net",
 *         },
 *         Kind = "IOT",
 *         Name = "IoTRole1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         RoleStatus = AzureNative.DataBoxEdge.RoleStatus.Enabled,
 *         ShareMappings = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewIoTRole(ctx, "ioTRole", &databoxedge.IoTRoleArgs{
 * 			DeviceName:   pulumi.String("testedgedevice"),
 * 			HostPlatform: pulumi.String(databoxedge.PlatformTypeLinux),
 * 			IoTDeviceDetails: &databoxedge.IoTDeviceInfoArgs{
 * 				Authentication: &databoxedge.AuthenticationArgs{
 * 					SymmetricKey: &databoxedge.SymmetricKeyArgs{
 * 						ConnectionString: &databoxedge.AsymmetricEncryptedSecretArgs{
 * 							EncryptionAlgorithm:      pulumi.String(databoxedge.EncryptionAlgorithmAES256),
 * 							EncryptionCertThumbprint: pulumi.String("348586569999244"),
 * 							Value:                    pulumi.String("Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotDevice;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>"),
 * 						},
 * 					},
 * 				},
 * 				DeviceId:   pulumi.String("iotdevice"),
 * 				IoTHostHub: pulumi.String("iothub.azure-devices.net"),
 * 			},
 * 			IoTEdgeDeviceDetails: &databoxedge.IoTDeviceInfoArgs{
 * 				Authentication: &databoxedge.AuthenticationArgs{
 * 					SymmetricKey: &databoxedge.SymmetricKeyArgs{
 * 						ConnectionString: &databoxedge.AsymmetricEncryptedSecretArgs{
 * 							EncryptionAlgorithm:      pulumi.String(databoxedge.EncryptionAlgorithmAES256),
 * 							EncryptionCertThumbprint: pulumi.String("1245475856069999244"),
 * 							Value:                    pulumi.String("Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotEdge;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>"),
 * 						},
 * 					},
 * 				},
 * 				DeviceId:   pulumi.String("iotEdge"),
 * 				IoTHostHub: pulumi.String("iothub.azure-devices.net"),
 * 			},
 * 			Kind:              pulumi.String("IOT"),
 * 			Name:              pulumi.String("IoTRole1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			RoleStatus:        pulumi.String(databoxedge.RoleStatusEnabled),
 * 			ShareMappings:     databoxedge.MountPointMapArray{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.IoTRole;
 * import com.pulumi.azurenative.databoxedge.IoTRoleArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.IoTDeviceInfoArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.AuthenticationArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.SymmetricKeyArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.AsymmetricEncryptedSecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ioTRole = new IoTRole("ioTRole", IoTRoleArgs.builder()
 *             .deviceName("testedgedevice")
 *             .hostPlatform("Linux")
 *             .ioTDeviceDetails(IoTDeviceInfoArgs.builder()
 *                 .authentication(AuthenticationArgs.builder()
 *                     .symmetricKey(SymmetricKeyArgs.builder()
 *                         .connectionString(AsymmetricEncryptedSecretArgs.builder()
 *                             .encryptionAlgorithm("AES256")
 *                             .encryptionCertThumbprint("348586569999244")
 *                             .value("Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotDevice;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .deviceId("iotdevice")
 *                 .ioTHostHub("iothub.azure-devices.net")
 *                 .build())
 *             .ioTEdgeDeviceDetails(IoTDeviceInfoArgs.builder()
 *                 .authentication(AuthenticationArgs.builder()
 *                     .symmetricKey(SymmetricKeyArgs.builder()
 *                         .connectionString(AsymmetricEncryptedSecretArgs.builder()
 *                             .encryptionAlgorithm("AES256")
 *                             .encryptionCertThumbprint("1245475856069999244")
 *                             .value("Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotEdge;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .deviceId("iotEdge")
 *                 .ioTHostHub("iothub.azure-devices.net")
 *                 .build())
 *             .kind("IOT")
 *             .name("IoTRole1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .roleStatus("Enabled")
 *             .shareMappings()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:IoTRole IoTRole1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{name}
 * ```
 * @property computeResource Resource allocation
 * @property deviceName The device name.
 * @property hostPlatform Host OS supported by the IoT role.
 * @property ioTDeviceDetails IoT device metadata to which data box edge device needs to be connected.
 * @property ioTEdgeAgentInfo Iot edge agent details to download the agent and bootstrap iot runtime.
 * @property ioTEdgeDeviceDetails IoT edge device to which the IoT role needs to be configured.
 * @property kind Role type.
 * Expected value is 'IOT'.
 * @property name The role name.
 * @property resourceGroupName The resource group name.
 * @property roleStatus Role status.
 * @property shareMappings Mount points of shares in role(s).
 */
public data class IoTRoleArgs(
    public val computeResource: Output<ComputeResourceArgs>? = null,
    public val deviceName: Output<String>? = null,
    public val hostPlatform: Output<Either<String, PlatformType>>? = null,
    public val ioTDeviceDetails: Output<IoTDeviceInfoArgs>? = null,
    public val ioTEdgeAgentInfo: Output<IoTEdgeAgentInfoArgs>? = null,
    public val ioTEdgeDeviceDetails: Output<IoTDeviceInfoArgs>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val roleStatus: Output<Either<String, RoleStatus>>? = null,
    public val shareMappings: Output<List<MountPointMapArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.IoTRoleArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.IoTRoleArgs =
        com.pulumi.azurenative.databoxedge.IoTRoleArgs.builder()
            .computeResource(computeResource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .hostPlatform(
                hostPlatform?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ioTDeviceDetails(ioTDeviceDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ioTEdgeAgentInfo(ioTEdgeAgentInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ioTEdgeDeviceDetails(
                ioTEdgeDeviceDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .roleStatus(
                roleStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .shareMappings(
                shareMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IoTRoleArgs].
 */
@PulumiTagMarker
public class IoTRoleArgsBuilder internal constructor() {
    private var computeResource: Output<ComputeResourceArgs>? = null

    private var deviceName: Output<String>? = null

    private var hostPlatform: Output<Either<String, PlatformType>>? = null

    private var ioTDeviceDetails: Output<IoTDeviceInfoArgs>? = null

    private var ioTEdgeAgentInfo: Output<IoTEdgeAgentInfoArgs>? = null

    private var ioTEdgeDeviceDetails: Output<IoTDeviceInfoArgs>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var roleStatus: Output<Either<String, RoleStatus>>? = null

    private var shareMappings: Output<List<MountPointMapArgs>>? = null

    /**
     * @param value Resource allocation
     */
    @JvmName("emdfrpvyhhiyifke")
    public suspend fun computeResource(`value`: Output<ComputeResourceArgs>) {
        this.computeResource = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("mftpxehxsvdveroj")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Host OS supported by the IoT role.
     */
    @JvmName("oppwhikdsrfliudi")
    public suspend fun hostPlatform(`value`: Output<Either<String, PlatformType>>) {
        this.hostPlatform = value
    }

    /**
     * @param value IoT device metadata to which data box edge device needs to be connected.
     */
    @JvmName("itkfaiwjhqfhlsef")
    public suspend fun ioTDeviceDetails(`value`: Output<IoTDeviceInfoArgs>) {
        this.ioTDeviceDetails = value
    }

    /**
     * @param value Iot edge agent details to download the agent and bootstrap iot runtime.
     */
    @JvmName("lxmjiljnatcogwqk")
    public suspend fun ioTEdgeAgentInfo(`value`: Output<IoTEdgeAgentInfoArgs>) {
        this.ioTEdgeAgentInfo = value
    }

    /**
     * @param value IoT edge device to which the IoT role needs to be configured.
     */
    @JvmName("xfoksmlmtughvhkq")
    public suspend fun ioTEdgeDeviceDetails(`value`: Output<IoTDeviceInfoArgs>) {
        this.ioTEdgeDeviceDetails = value
    }

    /**
     * @param value Role type.
     * Expected value is 'IOT'.
     */
    @JvmName("fvibkmyccmuallbq")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The role name.
     */
    @JvmName("sgxidtygiwybxoyk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qvuhivffysvtbbqc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Role status.
     */
    @JvmName("kosavcilqjegikiw")
    public suspend fun roleStatus(`value`: Output<Either<String, RoleStatus>>) {
        this.roleStatus = value
    }

    /**
     * @param value Mount points of shares in role(s).
     */
    @JvmName("rualhaeohuaeucuy")
    public suspend fun shareMappings(`value`: Output<List<MountPointMapArgs>>) {
        this.shareMappings = value
    }

    @JvmName("xjwhwxmojfayxskm")
    public suspend fun shareMappings(vararg values: Output<MountPointMapArgs>) {
        this.shareMappings = Output.all(values.asList())
    }

    /**
     * @param values Mount points of shares in role(s).
     */
    @JvmName("pkndvlwkdmiewlpa")
    public suspend fun shareMappings(values: List<Output<MountPointMapArgs>>) {
        this.shareMappings = Output.all(values)
    }

    /**
     * @param value Resource allocation
     */
    @JvmName("tuhdnvqglbwjlppy")
    public suspend fun computeResource(`value`: ComputeResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeResource = mapped
    }

    /**
     * @param argument Resource allocation
     */
    @JvmName("jsbxvypojouxttpc")
    public suspend fun computeResource(argument: suspend ComputeResourceArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.computeResource = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("gltrhnbdmyqdkajh")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Host OS supported by the IoT role.
     */
    @JvmName("fixtjpadsfpslndp")
    public suspend fun hostPlatform(`value`: Either<String, PlatformType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPlatform = mapped
    }

    /**
     * @param value Host OS supported by the IoT role.
     */
    @JvmName("lhnabrgbrtffthay")
    public fun hostPlatform(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PlatformType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostPlatform = mapped
    }

    /**
     * @param value Host OS supported by the IoT role.
     */
    @JvmName("yabswohkoxtfhgmg")
    public fun hostPlatform(`value`: PlatformType) {
        val toBeMapped = Either.ofRight<String, PlatformType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostPlatform = mapped
    }

    /**
     * @param value IoT device metadata to which data box edge device needs to be connected.
     */
    @JvmName("iqfruktawhhkboam")
    public suspend fun ioTDeviceDetails(`value`: IoTDeviceInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ioTDeviceDetails = mapped
    }

    /**
     * @param argument IoT device metadata to which data box edge device needs to be connected.
     */
    @JvmName("ixwusoiaobidyiui")
    public suspend fun ioTDeviceDetails(argument: suspend IoTDeviceInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IoTDeviceInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ioTDeviceDetails = mapped
    }

    /**
     * @param value Iot edge agent details to download the agent and bootstrap iot runtime.
     */
    @JvmName("iudhljigixakaofh")
    public suspend fun ioTEdgeAgentInfo(`value`: IoTEdgeAgentInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ioTEdgeAgentInfo = mapped
    }

    /**
     * @param argument Iot edge agent details to download the agent and bootstrap iot runtime.
     */
    @JvmName("fwgvimpblmvosfrg")
    public suspend fun ioTEdgeAgentInfo(argument: suspend IoTEdgeAgentInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IoTEdgeAgentInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ioTEdgeAgentInfo = mapped
    }

    /**
     * @param value IoT edge device to which the IoT role needs to be configured.
     */
    @JvmName("mjnxatdveeifmrme")
    public suspend fun ioTEdgeDeviceDetails(`value`: IoTDeviceInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ioTEdgeDeviceDetails = mapped
    }

    /**
     * @param argument IoT edge device to which the IoT role needs to be configured.
     */
    @JvmName("uogerrvnacfjssil")
    public suspend fun ioTEdgeDeviceDetails(argument: suspend IoTDeviceInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IoTDeviceInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ioTEdgeDeviceDetails = mapped
    }

    /**
     * @param value Role type.
     * Expected value is 'IOT'.
     */
    @JvmName("wflqmqrvflnspiib")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("bniapxwrpmnncbyr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("akemsnqrfsttblfw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("fkyvcvgywuvkmypy")
    public suspend fun roleStatus(`value`: Either<String, RoleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("vaplelftgbjhbael")
    public fun roleStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("qvcrdfkqkvxtxlhw")
    public fun roleStatus(`value`: RoleStatus) {
        val toBeMapped = Either.ofRight<String, RoleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    /**
     * @param value Mount points of shares in role(s).
     */
    @JvmName("lsbktafpkntjumuv")
    public suspend fun shareMappings(`value`: List<MountPointMapArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareMappings = mapped
    }

    /**
     * @param argument Mount points of shares in role(s).
     */
    @JvmName("perotynjjdtiyhud")
    public suspend fun shareMappings(argument: List<suspend MountPointMapArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MountPointMapArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.shareMappings = mapped
    }

    /**
     * @param argument Mount points of shares in role(s).
     */
    @JvmName("tmtvqbywqgnjulrm")
    public suspend fun shareMappings(vararg argument: suspend MountPointMapArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MountPointMapArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.shareMappings = mapped
    }

    /**
     * @param argument Mount points of shares in role(s).
     */
    @JvmName("llqoeppduswsjaxn")
    public suspend fun shareMappings(argument: suspend MountPointMapArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MountPointMapArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.shareMappings = mapped
    }

    /**
     * @param values Mount points of shares in role(s).
     */
    @JvmName("qjmbqxrpdpagyrnf")
    public suspend fun shareMappings(vararg values: MountPointMapArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shareMappings = mapped
    }

    internal fun build(): IoTRoleArgs = IoTRoleArgs(
        computeResource = computeResource,
        deviceName = deviceName,
        hostPlatform = hostPlatform,
        ioTDeviceDetails = ioTDeviceDetails,
        ioTEdgeAgentInfo = ioTEdgeAgentInfo,
        ioTEdgeDeviceDetails = ioTEdgeDeviceDetails,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        roleStatus = roleStatus,
        shareMappings = shareMappings,
    )
}
