@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.MECRoleArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.RoleStatus
import com.pulumi.azurenative.databoxedge.kotlin.inputs.AsymmetricEncryptedSecretArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.AsymmetricEncryptedSecretArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * MEC role.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### RolePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mecRole = new AzureNative.DataBoxEdge.MECRole("mecRole", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         Name = "IoTRole1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewMECRole(ctx, "mecRole", &databoxedge.MECRoleArgs{
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("IoTRole1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.MECRole;
 * import com.pulumi.azurenative.databoxedge.MECRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mecRole = new MECRole("mecRole", MECRoleArgs.builder()
 *             .deviceName("testedgedevice")
 *             .name("IoTRole1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:MECRole IoTRole1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{name}
 * ```
 * @property connectionString Activation key of the MEC.
 * @property controllerEndpoint Controller Endpoint.
 * @property deviceName The device name.
 * @property kind Role type.
 * Expected value is 'MEC'.
 * @property name The role name.
 * @property resourceGroupName The resource group name.
 * @property resourceUniqueId Unique Id of the Resource.
 * @property roleStatus Role status.
 */
public data class MECRoleArgs(
    public val connectionString: Output<AsymmetricEncryptedSecretArgs>? = null,
    public val controllerEndpoint: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceUniqueId: Output<String>? = null,
    public val roleStatus: Output<Either<String, RoleStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.MECRoleArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.MECRoleArgs =
        com.pulumi.azurenative.databoxedge.MECRoleArgs.builder()
            .connectionString(connectionString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .controllerEndpoint(controllerEndpoint?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceUniqueId(resourceUniqueId?.applyValue({ args0 -> args0 }))
            .roleStatus(
                roleStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [MECRoleArgs].
 */
@PulumiTagMarker
public class MECRoleArgsBuilder internal constructor() {
    private var connectionString: Output<AsymmetricEncryptedSecretArgs>? = null

    private var controllerEndpoint: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceUniqueId: Output<String>? = null

    private var roleStatus: Output<Either<String, RoleStatus>>? = null

    /**
     * @param value Activation key of the MEC.
     */
    @JvmName("yraskakmkjbmomfw")
    public suspend fun connectionString(`value`: Output<AsymmetricEncryptedSecretArgs>) {
        this.connectionString = value
    }

    /**
     * @param value Controller Endpoint.
     */
    @JvmName("nxajlrkjlgelyfib")
    public suspend fun controllerEndpoint(`value`: Output<String>) {
        this.controllerEndpoint = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("yswgtgtjndmrmhsy")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Role type.
     * Expected value is 'MEC'.
     */
    @JvmName("obrxtuakqdwlknel")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The role name.
     */
    @JvmName("gxoxtxcfodgpifqc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("eqxmrswabafyipjk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Unique Id of the Resource.
     */
    @JvmName("mfkkxepriggpyeja")
    public suspend fun resourceUniqueId(`value`: Output<String>) {
        this.resourceUniqueId = value
    }

    /**
     * @param value Role status.
     */
    @JvmName("qitqnjjvudbxxsit")
    public suspend fun roleStatus(`value`: Output<Either<String, RoleStatus>>) {
        this.roleStatus = value
    }

    /**
     * @param value Activation key of the MEC.
     */
    @JvmName("ueodmwcktdunsxqr")
    public suspend fun connectionString(`value`: AsymmetricEncryptedSecretArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param argument Activation key of the MEC.
     */
    @JvmName("xfvblpcectigvxsv")
    public suspend fun connectionString(argument: suspend AsymmetricEncryptedSecretArgsBuilder.() -> Unit) {
        val toBeMapped = AsymmetricEncryptedSecretArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionString = mapped
    }

    /**
     * @param value Controller Endpoint.
     */
    @JvmName("wywuqjqmiqgisjma")
    public suspend fun controllerEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controllerEndpoint = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("mufudmdlclonmlvh")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Role type.
     * Expected value is 'MEC'.
     */
    @JvmName("sbrvxwcybtcebxhw")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("pumdlkcbehjwflod")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("nnjbyeqkjwxrbjxs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Unique Id of the Resource.
     */
    @JvmName("bnqysrqeaquiinxr")
    public suspend fun resourceUniqueId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUniqueId = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("dedtdavhiueyinkw")
    public suspend fun roleStatus(`value`: Either<String, RoleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("ayoaemsmfyxamawp")
    public fun roleStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("cdgkgudstvpxsgbe")
    public fun roleStatus(`value`: RoleStatus) {
        val toBeMapped = Either.ofRight<String, RoleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    internal fun build(): MECRoleArgs = MECRoleArgs(
        connectionString = connectionString,
        controllerEndpoint = controllerEndpoint,
        deviceName = deviceName,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        resourceUniqueId = resourceUniqueId,
        roleStatus = roleStatus,
    )
}
