@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.MetricConfigurationResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.databoxedge.kotlin.outputs.MetricConfigurationResponse.Companion.toKotlin as metricConfigurationResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MonitoringConfig].
 */
@PulumiTagMarker
public class MonitoringConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MonitoringConfigArgs = MonitoringConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MonitoringConfigArgsBuilder.() -> Unit) {
        val builder = MonitoringConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MonitoringConfig {
        val builtJavaResource =
            com.pulumi.azurenative.databoxedge.MonitoringConfig(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MonitoringConfig(builtJavaResource)
    }
}

/**
 * The metric setting details for the role
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### PutMonitoringConfig
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitoringConfig = new AzureNative.DataBoxEdge.MonitoringConfig("monitoringConfig", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         MetricConfigurations = new[]
 *         {
 *             new AzureNative.DataBoxEdge.Inputs.MetricConfigurationArgs
 *             {
 *                 CounterSets = new[]
 *                 {
 *                     new AzureNative.DataBoxEdge.Inputs.MetricCounterSetArgs
 *                     {
 *                         Counters = new[]
 *                         {
 *                             new AzureNative.DataBoxEdge.Inputs.MetricCounterArgs
 *                             {
 *                                 Name = "test",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 MdmAccount = "test",
 *                 MetricNameSpace = "test",
 *                 ResourceId = "test",
 *             },
 *         },
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         RoleName = "testrole",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewMonitoringConfig(ctx, "monitoringConfig", &databoxedge.MonitoringConfigArgs{
 * 			DeviceName: pulumi.String("testedgedevice"),
 * 			MetricConfigurations: databoxedge.MetricConfigurationArray{
 * 				&databoxedge.MetricConfigurationArgs{
 * 					CounterSets: databoxedge.MetricCounterSetArray{
 * 						&databoxedge.MetricCounterSetArgs{
 * 							Counters: databoxedge.MetricCounterArray{
 * 								&databoxedge.MetricCounterArgs{
 * 									Name: pulumi.String("test"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					MdmAccount:      pulumi.String("test"),
 * 					MetricNameSpace: pulumi.String("test"),
 * 					ResourceId:      pulumi.String("test"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			RoleName:          pulumi.String("testrole"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.MonitoringConfig;
 * import com.pulumi.azurenative.databoxedge.MonitoringConfigArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.MetricConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitoringConfig = new MonitoringConfig("monitoringConfig", MonitoringConfigArgs.builder()
 *             .deviceName("testedgedevice")
 *             .metricConfigurations(MetricConfigurationArgs.builder()
 *                 .counterSets(MetricCounterSetArgs.builder()
 *                     .counters(MetricCounterArgs.builder()
 *                         .name("test")
 *                         .build())
 *                     .build())
 *                 .mdmAccount("test")
 *                 .metricNameSpace("test")
 *                 .resourceId("test")
 *                 .build())
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .roleName("testrole")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:MonitoringConfig myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{roleName}/monitoringConfig/default
 * ```
 */
public class MonitoringConfig internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.MonitoringConfig,
) : KotlinCustomResource(javaResource, MonitoringConfigMapper) {
    /**
     * The metrics configuration details
     */
    public val metricConfigurations: Output<List<MetricConfigurationResponse>>
        get() = javaResource.metricConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> metricConfigurationResponseToKotlin(args0) })
            })
        })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of MonitoringConfiguration
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MonitoringConfigMapper : ResourceMapper<MonitoringConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.MonitoringConfig::class == javaResource::class

    override fun map(javaResource: Resource): MonitoringConfig = MonitoringConfig(
        javaResource as
            com.pulumi.azurenative.databoxedge.MonitoringConfig,
    )
}

/**
 * @see [MonitoringConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MonitoringConfig].
 */
public suspend fun monitoringConfig(
    name: String,
    block: suspend MonitoringConfigResourceBuilder.() -> Unit,
): MonitoringConfig {
    val builder = MonitoringConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MonitoringConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun monitoringConfig(name: String): MonitoringConfig {
    val builder = MonitoringConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
